/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.utils;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.techcable.srglib.utils.CheckedBiConsumer;
import net.techcable.srglib.utils.CheckedConsumer;
import net.techcable.srglib.utils.CheckedRunnable;
import net.techcable.srglib.utils.CheckedSupplier;

public final class Exceptions {
    private Exceptions() {
    }

    public static <T, U> BiConsumer<T, U> sneakyThrowing(CheckedBiConsumer<T, U, Throwable> consumer) {
        return (first, second) -> {
            try {
                consumer.accept(first, second);
            }
            catch (Throwable e) {
                throw Exceptions.sneakyThrow(e);
            }
        };
    }

    public static <T> Consumer<T> sneakyThrowing(CheckedConsumer<T, Throwable> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable e) {
                throw Exceptions.sneakyThrow(e);
            }
        };
    }

    public static Runnable sneakyThrowing(CheckedRunnable<Throwable> r) {
        return () -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throw Exceptions.sneakyThrow(t);
            }
        };
    }

    public static <T> Supplier<T> sneakyThrowing(CheckedSupplier<T, Throwable> r) {
        return () -> {
            try {
                return r.get();
            }
            catch (Throwable t) {
                throw Exceptions.sneakyThrow(t);
            }
        };
    }

    public static AssertionError sneakyThrow(Throwable t) {
        throw Exceptions.sneakyThrow0(t);
    }

    private static <T extends Throwable> AssertionError sneakyThrow0(Throwable t) throws T {
        throw t;
    }
}

