/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1535;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.Art;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.jetbrains.annotations.NotNull;

public class CraftArt
implements Art,
Handleable<class_1535> {
    private static int count = 0;
    private final NamespacedKey key;
    private final class_1535 paintingVariant;
    private final String name;
    private final int ordinal;

    public static Art minecraftToBukkit(class_1535 minecraft) {
        return (Art)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41209);
    }

    public static Art minecraftHolderToBukkit(class_6880<class_1535> minecraft) {
        return CraftArt.minecraftToBukkit((class_1535)minecraft.comp_349());
    }

    public static class_1535 bukkitToMinecraft(Art bukkit) {
        return (class_1535)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_1535> bukkitToMinecraftHolder(Art bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41209);
        class_6880 registryEntry = registry.method_47983((Object)CraftArt.bukkitToMinecraft(bukkit));
        if (registryEntry instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)registryEntry;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own painting variant with out properly registering it.");
    }

    public CraftArt(NamespacedKey key, class_1535 paintingVariant) {
        this.key = key;
        this.paintingVariant = paintingVariant;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public class_1535 getHandle() {
        return this.paintingVariant;
    }

    public int getBlockWidth() {
        return this.paintingVariant.comp_2670();
    }

    public int getBlockHeight() {
        return this.paintingVariant.comp_2671();
    }

    public Component title() {
        return this.paintingVariant.comp_2918().map(PaperAdventure::asAdventure).orElse(null);
    }

    public Component author() {
        return this.paintingVariant.comp_2919().map(PaperAdventure::asAdventure).orElse(null);
    }

    public Key assetId() {
        return CardboardAdventure.asAdventure(this.paintingVariant.comp_2672());
    }

    public int getId() {
        return CraftRegistry.getMinecraftRegistry(class_7924.field_41209).method_10206((Object)this.paintingVariant);
    }

    @NotNull
    public NamespacedKey getKey() {
        return Objects.requireNonNull(Registry.ART.getKey((Keyed)this), () -> String.valueOf(this) + " doesn't have a key");
    }

    public int compareTo(@NotNull Art art) {
        return this.ordinal - art.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftArt)) {
            return false;
        }
        CraftArt otherArt = (CraftArt)other;
        return this.getKey().equals((Object)otherArt.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

