/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.world.MoonPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1686;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2279;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_6808;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftHeightMap;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.cardboardpowered.TeleportTargetExtra;
import org.jetbrains.annotations.NotNull;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract class_5281 getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof class_3218;
    }

    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Biome getBiome(int x, int y, int z) {
        return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)this.getHandle().method_16359(x >> 2, y >> 2, z >> 2));
    }

    public Biome getComputedBiome(int x, int y, int z) {
        return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)this.getHandle().method_23753(new class_2338(x, y, z)));
    }

    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int x, int y, int z, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        class_6880<class_1959> biomeBase = CraftBiome.bukkitToMinecraftHolder(biome);
        this.setBiome(x, y, z, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, class_6880<class_1959> var4);

    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockState getBlockState(int x, int y, int z) {
        return CraftBlock.at((class_3218)this.getHandle(), new class_2338(x, y, z)).getState();
    }

    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getData(x, y, z));
    }

    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Material getType(int x, int y, int z) {
        return CraftBlockType.minecraftToBukkit(this.getData(x, y, z).method_26204());
    }

    protected class_2680 getData(int x, int y, int z) {
        return this.getHandle().method_8320(new class_2338(x, y, z));
    }

    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    public void setBlockData(int x, int y, int z, BlockData blockData) {
        class_5281 world = this.getHandle();
        class_2338 pos = new class_2338(x, y, z);
        class_2680 old = this.getHandle().method_8320(pos);
        CraftBlock.setTypeAndData((class_1936)((class_3218)world), pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    public void setType(int x, int y, int z, Material material) {
        this.setBlockData(x, y, z, material.createBlockData());
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        return this.getHandle().method_8624(CraftHeightMap.toNMS(heightMap), x, z);
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType) {
        class_2338 pos = CraftLocation.toBlockPosition(location);
        class_2794 gen = ((class_3218)this.getHandle()).method_14178().method_12129();
        return this.generateTree(this.getHandle(), gen, pos, new RandomSourceWrapper(random), treeType);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        });
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<? super BlockState> predicate) {
        return false;
    }

    public boolean generateTree(class_5281 access, class_2794 chunkGenerator, class_2338 pos, class_5819 random, TreeType treeType) {
        class_5321 gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = class_6808.field_35912;
                break;
            }
            case BIRCH: {
                gen = class_6808.field_35907;
                break;
            }
            case REDWOOD: {
                gen = class_6808.field_35909;
                break;
            }
            case TALL_REDWOOD: {
                gen = class_6808.field_35910;
                break;
            }
            case JUNGLE: {
                gen = class_6808.field_35914;
                break;
            }
            case SMALL_JUNGLE: {
                gen = class_6808.field_35913;
                break;
            }
            case COCOA_TREE: {
                gen = class_6808.field_35911;
                break;
            }
            case JUNGLE_BUSH: {
                gen = class_6808.field_35920;
                break;
            }
            case RED_MUSHROOM: {
                gen = class_6808.field_35904;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = class_6808.field_35903;
                break;
            }
            case SWAMP: {
                gen = class_6808.field_35919;
                break;
            }
            case ACACIA: {
                gen = class_6808.field_35908;
                break;
            }
            case DARK_OAK: {
                gen = class_6808.field_35906;
                break;
            }
            case MEGA_REDWOOD: {
                gen = class_6808.field_35916;
                break;
            }
            case TALL_BIRCH: {
                gen = class_6808.field_35917;
                break;
            }
            case CHORUS_PLANT: {
                class_2279 cfr_ignored_0 = (class_2279)class_2246.field_10528;
                class_2279.method_9744((class_1936)access, (class_2338)pos, (class_5819)random, (int)8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = this.isNormalWorld() ? class_6808.field_35900 : class_6808.field_35899;
                break;
            }
            case WARPED_FUNGUS: {
                gen = this.isNormalWorld() ? class_6808.field_35902 : class_6808.field_35901;
                break;
            }
            case AZALEA: {
                gen = class_6808.field_35921;
                break;
            }
            case MANGROVE: {
                gen = class_6808.field_38810;
                break;
            }
            case TALL_MANGROVE: {
                gen = class_6808.field_38811;
                break;
            }
            case CHERRY: {
                gen = class_6808.field_42960;
                break;
            }
            default: {
                gen = class_6808.field_35905;
            }
        }
        class_6880 holder = access.method_30349().method_30530(class_7924.field_41239).method_46746(gen).orElse(null);
        return holder != null ? ((class_2975)holder.comp_349()).method_12862(access, chunkGenerator, random, pos) : false;
    }

    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<class_1297> getNMSEntities();

    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            // empty if block
        }
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(T entity) {
        class_1297 nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity.method_73183() != this.getHandle().method_8410()) {
            nmsEntity = nmsEntity.method_5731(TeleportTargetExtra.newTeleportTarget(this.getHandle().method_8410(), nmsEntity, class_5454.field_52245));
        }
        this.addEntityWithPassengers(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (T)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason, Consumer<? super T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)this.getHandle(), this.getHandle().method_8404(entity.method_24515()), class_3730.field_16462, null);
        }
        if (!this.isNormalWorld()) {
            // empty if block
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(class_1297 var1, CreatureSpawnEvent.SpawnReason var2);

    public abstract void addEntityWithPassengers(class_1297 var1, CreatureSpawnEvent.SpawnReason var2);

    public class_1297 makeEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    public abstract class_1297 createEntity_Old(Location var1, Class<? extends Entity> var2) throws IllegalArgumentException;

    public class_1297 createEntity(Location location, Class<? extends Entity> clazz_org, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz_org != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Class<? extends Entity> clazz = clazz_org;
        Consumer<class_1297> runOld = other -> {};
        if (clazz == AbstractArrow.class) {
            clazz = Arrow.class;
        } else if (clazz == AbstractHorse.class) {
            clazz = Horse.class;
        } else if (clazz == Fireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == LingeringPotion.class) {
            clazz = ThrownPotion.class;
            runOld = other -> ((class_1686)other).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
        } else if (clazz == Minecart.class) {
            clazz = RideableMinecart.class;
        } else if (clazz == SizedFireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == SplashPotion.class) {
            clazz = ThrownPotion.class;
        } else if (clazz == TippedArrow.class) {
            clazz = Arrow.class;
            runOld = other -> ((Arrow)other.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(clazz);
        if (entityTypeData == null || entityTypeData.spawnFunction() == null) {
            try {
                class_1297 entity = this.createEntity_Old(location, clazz_org);
                if (entity != null) {
                    runOld.accept(entity);
                    return entity;
                }
            }
            catch (IllegalArgumentException entity) {
                // empty catch block
            }
            if (CraftEntity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("Cannot spawn an entity from its CraftBukkit implementation class '%s' use the Bukkit class instead. You can get the Bukkit representation via Entity#getType()#getEntityClass()", clazz.getName()));
            }
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        }
        class_1297 entity = (class_1297)entityTypeData.spawnFunction().apply(new CraftEntityTypes.SpawnData(this.getHandle(), location, randomizeData, this.isNormalWorld()));
        if (entity != null) {
            runOld.accept(entity);
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public MoonPhase getMoonPhase() {
        return MoonPhase.getPhase((long)(this.getHandle().method_30271() / 24000L));
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.getHandle().method_8410().method_27983().method_29177());
    }

    public boolean lineOfSightExists(Location from, Location to) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"from parameter in lineOfSightExists cannot be null");
        Preconditions.checkArgument((to != null ? 1 : 0) != 0, (Object)"to parameter in lineOfSightExists cannot be null");
        if (from.getWorld() != to.getWorld()) {
            return false;
        }
        class_243 start = new class_243(from.getX(), from.getY(), from.getZ());
        class_243 end = new class_243(to.getX(), to.getY(), to.getZ());
        if (end.method_1025(start) > 16384.0) {
            return false;
        }
        return this.getHandle().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194())).method_17783() == class_239.class_240.field_1333;
    }

    public boolean hasCollisionsIn(@NotNull BoundingBox boundingBox) {
        class_238 aabb = new class_238(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().method_18026(aabb);
    }
}

