/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.cardboardpowered.impl.block.CardboardBanner;
import org.cardboardpowered.impl.block.CardboardBarrel;
import org.cardboardpowered.impl.block.CardboardBeacon;
import org.cardboardpowered.impl.block.CardboardBed;
import org.cardboardpowered.impl.block.CardboardBeehive;
import org.cardboardpowered.impl.block.CardboardBell;
import org.cardboardpowered.impl.block.CardboardBlastFurnace;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.block.CardboardBrewingStand;
import org.cardboardpowered.impl.block.CardboardCampfire;
import org.cardboardpowered.impl.block.CardboardChest;
import org.cardboardpowered.impl.block.CardboardCommandBlock;
import org.cardboardpowered.impl.block.CardboardComparator;
import org.cardboardpowered.impl.block.CardboardConduit;
import org.cardboardpowered.impl.block.CardboardDaylightDetector;
import org.cardboardpowered.impl.block.CardboardDispenser;
import org.cardboardpowered.impl.block.CardboardDropper;
import org.cardboardpowered.impl.block.CardboardEnchantingTable;
import org.cardboardpowered.impl.block.CardboardEndGateway;
import org.cardboardpowered.impl.block.CardboardEnderchest;
import org.cardboardpowered.impl.block.CardboardFurnaceFurnace;
import org.cardboardpowered.impl.block.CardboardHopper;
import org.cardboardpowered.impl.block.CardboardJigsaw;
import org.cardboardpowered.impl.block.CardboardJukebox;
import org.cardboardpowered.impl.block.CardboardLectern;
import org.cardboardpowered.impl.block.CardboardMobspawner;
import org.cardboardpowered.impl.block.CardboardShulkerBox;
import org.cardboardpowered.impl.block.CardboardSign;
import org.cardboardpowered.impl.block.CardboardSkull;
import org.cardboardpowered.impl.block.CardboardSmoker;
import org.cardboardpowered.impl.block.CardboardStructureBlock;
import org.cardboardpowered.impl.block.CraftBrushableBlock;
import org.cardboardpowered.impl.block.CraftCalibratedSculkSensor;
import org.cardboardpowered.impl.block.CraftChiseledBookshelf;
import org.cardboardpowered.impl.block.CraftCrafter;
import org.cardboardpowered.impl.block.CraftDecoratedPot;
import org.cardboardpowered.impl.block.CraftEndPortal;
import org.cardboardpowered.impl.block.CraftHangingSign;
import org.cardboardpowered.impl.block.CraftMovingPiston;
import org.cardboardpowered.impl.block.CraftSculkCatalyst;
import org.cardboardpowered.impl.block.CraftSculkSensor;
import org.cardboardpowered.impl.block.CraftSculkShrieker;
import org.cardboardpowered.impl.block.CraftTrialSpawner;
import org.cardboardpowered.impl.block.CraftVault;
import org.cardboardpowered.impl.world.CraftWorld;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftBlockType.minecraftToBukkit(blockData.method_26204()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };
    private static final Map<class_2591<?>, BlockStateFactory<?>> FACTORIES_BY_BLOCK_ENTITY_TYPE = new HashMap();

    private static void register(class_2591<?> type, BlockStateFactory<?> factory) {
        FACTORIES_BY_BLOCK_ENTITY_TYPE.put(type, factory);
    }

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends class_2586, B extends CardboardBlockEntityState<T>> void register(class_2591<? extends T> blockEntityType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor) {
        BlockEntityStateFactory<? extends T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, blockEntityType);
        for (class_2248 block : blockEntityType.field_19315) {
            CraftBlockStates.register(CraftBlockType.minecraftToBukkit(block), factory);
        }
        CraftBlockStates.register(blockEntityType, factory);
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    private static BlockStateFactory<?> getFactory(Material material, class_2591<?> type) {
        if (type != null) {
            return FACTORIES_BY_BLOCK_ENTITY_TYPE.getOrDefault(type, CraftBlockStates.getFactory(material));
        }
        return CraftBlockStates.getFactory(material);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static class_2586 createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(class_2338.field_10980, CraftBlockType.bukkitToMinecraft(material).method_9564());
        }
        return null;
    }

    public static Class<? extends CraftBlockState> getBlockStateType(class_2591<?> blockEntityType) {
        Preconditions.checkNotNull(blockEntityType, (Object)"blockEntityType is null");
        return CraftBlockStates.getFactory(null, blockEntityType).blockStateType;
    }

    public static BlockState getBlockState(Block block) {
        return CraftBlockStates.getBlockState(block, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockState getBlockState(Block block, boolean useSnapshot) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        class_2338 blockPosition = craftBlock.getPosition();
        class_2680 blockData = craftBlock.getNMS();
        class_2586 tileEntity = craftBlock.getHandle().method_8321(blockPosition);
        boolean prev = CardboardBlockEntityState.DISABLE_SNAPSHOT;
        CardboardBlockEntityState.DISABLE_SNAPSHOT = !useSnapshot;
        try {
            CraftBlockState craftBlockState;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
            blockState.setWorldHandle((class_1936)craftBlock.getHandle());
            CraftBlockState craftBlockState2 = craftBlockState = blockState;
            return craftBlockState2;
        }
        finally {
            CardboardBlockEntityState.DISABLE_SNAPSHOT = prev;
        }
    }

    @Deprecated
    public static BlockState getBlockState(class_2338 blockPosition, Material material, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState((class_5455)CraftServer.server.method_30611(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(class_4538 world, class_2338 blockPosition, Material material, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState(world.method_30349(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(class_5455 registry, class_2338 blockPosition, Material material, @Nullable class_2487 blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        class_2680 blockData = CraftBlockType.bukkitToMinecraft(material).method_9564();
        return CraftBlockStates.getBlockState(registry, blockPosition, blockData, blockEntityTag);
    }

    @Deprecated
    public static BlockState getBlockState(class_2680 blockData, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState((class_5455)CraftServer.server.method_30611(), class_2338.field_10980, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(class_4538 world, class_2338 blockPosition, class_2680 blockData, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState(world.method_30349(), blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(class_5455 registry, class_2338 blockPosition, class_2680 blockData, @Nullable class_2487 blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        class_2586 tileEntity = blockEntityTag == null ? null : class_2586.method_11005((class_2338)blockPosition, (class_2680)blockData, (class_2487)blockEntityTag, (class_7225.class_7874)registry);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    public static CraftBlockState getBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
        Material material = CraftBlockType.minecraftToBukkit(blockData.method_26204());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material, tileEntity != null ? tileEntity.method_11017() : null);
        return factory.createBlockState(world, blockPosition, blockData, tileEntity);
    }

    public static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(class_1936 world, class_2338 pos) {
        return new CraftBlockState(CraftBlock.at((class_3218)world, pos));
    }

    public static CraftBlockState getBlockState(class_1936 world, class_2338 pos, int flag) {
        return new CraftBlockState(CraftBlock.at((class_3218)world, pos), flag);
    }

    private CraftBlockStates() {
    }

    public static class_2586 createNewBlockEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createBlockEntity(class_2338.field_10980, CraftBlockType.bukkitToMinecraft(material).method_9564());
        }
        return null;
    }

    @Nullable
    public static class_2591<?> getBlockEntityType(Material material) {
        class_2591 blockEntityType;
        BlockStateFactory<?> factory = FACTORIES.get(material);
        if (factory instanceof BlockEntityStateFactory) {
            BlockEntityStateFactory blockEntityStateFactory = (BlockEntityStateFactory)factory;
            blockEntityType = blockEntityStateFactory.blockEntityType;
        } else {
            blockEntityType = null;
        }
        return blockEntityType;
    }

    static {
        CraftBlockStates.register(class_2591.field_11911, CardboardSign.class, CardboardSign::new);
        CraftBlockStates.register(class_2591.field_40330, CraftHangingSign.class, CraftHangingSign::new);
        CraftBlockStates.register(class_2591.field_11913, CardboardSkull.class, CardboardSkull::new);
        CraftBlockStates.register(class_2591.field_11904, CardboardCommandBlock.class, CardboardCommandBlock::new);
        CraftBlockStates.register(class_2591.field_11905, CardboardBanner.class, CardboardBanner::new);
        CraftBlockStates.register(class_2591.field_11896, CardboardShulkerBox.class, CardboardShulkerBox::new);
        CraftBlockStates.register(class_2591.field_11910, CardboardBed.class, CardboardBed::new);
        CraftBlockStates.register(class_2591.field_20431, CardboardBeehive.class, CardboardBeehive::new);
        CraftBlockStates.register(class_2591.field_17380, CardboardCampfire.class, CardboardCampfire::new);
        CraftBlockStates.register(class_2591.field_16411, CardboardBarrel.class, CardboardBarrel::new);
        CraftBlockStates.register(class_2591.field_11890, CardboardBeacon.class, CardboardBeacon::new);
        CraftBlockStates.register(class_2591.field_16413, CardboardBell.class, CardboardBell::new);
        CraftBlockStates.register(class_2591.field_16415, CardboardBlastFurnace.class, CardboardBlastFurnace::new);
        CraftBlockStates.register(class_2591.field_11894, CardboardBrewingStand.class, CardboardBrewingStand::new);
        CraftBlockStates.register(class_2591.field_11914, CardboardChest.class, CardboardChest::new);
        CraftBlockStates.register(class_2591.field_40329, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new);
        CraftBlockStates.register(class_2591.field_11908, CardboardComparator.class, CardboardComparator::new);
        CraftBlockStates.register(class_2591.field_11902, CardboardConduit.class, CardboardConduit::new);
        CraftBlockStates.register(class_2591.field_11900, CardboardDaylightDetector.class, CardboardDaylightDetector::new);
        CraftBlockStates.register(class_2591.field_42781, CraftDecoratedPot.class, CraftDecoratedPot::new);
        CraftBlockStates.register(class_2591.field_11887, CardboardDispenser.class, CardboardDispenser::new);
        CraftBlockStates.register(class_2591.field_11899, CardboardDropper.class, CardboardDropper::new);
        CraftBlockStates.register(class_2591.field_11912, CardboardEnchantingTable.class, CardboardEnchantingTable::new);
        CraftBlockStates.register(class_2591.field_11901, CardboardEnderchest.class, CardboardEnderchest::new);
        CraftBlockStates.register(class_2591.field_11906, CardboardEndGateway.class, CardboardEndGateway::new);
        CraftBlockStates.register(class_2591.field_11898, CraftEndPortal.class, CraftEndPortal::new);
        CraftBlockStates.register(class_2591.field_11903, CardboardFurnaceFurnace.class, CardboardFurnaceFurnace::new);
        CraftBlockStates.register(class_2591.field_11888, CardboardHopper.class, CardboardHopper::new);
        CraftBlockStates.register(class_2591.field_16549, CardboardJigsaw.class, CardboardJigsaw::new);
        CraftBlockStates.register(class_2591.field_11907, CardboardJukebox.class, CardboardJukebox::new);
        CraftBlockStates.register(class_2591.field_16412, CardboardLectern.class, CardboardLectern::new);
        CraftBlockStates.register(class_2591.field_11897, CraftMovingPiston.class, CraftMovingPiston::new);
        CraftBlockStates.register(class_2591.field_37647, CraftSculkCatalyst.class, CraftSculkCatalyst::new);
        CraftBlockStates.register(class_2591.field_28117, CraftSculkSensor.class, CraftSculkSensor::new);
        CraftBlockStates.register(class_2591.field_37648, CraftSculkShrieker.class, CraftSculkShrieker::new);
        CraftBlockStates.register(class_2591.field_43258, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new);
        CraftBlockStates.register(class_2591.field_16414, CardboardSmoker.class, CardboardSmoker::new);
        CraftBlockStates.register(class_2591.field_11889, CardboardMobspawner.class, CardboardMobspawner::new);
        CraftBlockStates.register(class_2591.field_11895, CardboardStructureBlock.class, CardboardStructureBlock::new);
        CraftBlockStates.register(class_2591.field_42780, CraftBrushableBlock.class, CraftBrushableBlock::new);
        CraftBlockStates.register(class_2591.field_11891, CardboardChest.class, CardboardChest::new);
        CraftBlockStates.register(class_2591.field_46808, CraftCrafter.class, CraftCrafter::new);
        CraftBlockStates.register(class_2591.field_47352, CraftTrialSpawner.class, CraftTrialSpawner::new);
        CraftBlockStates.register(class_2591.field_48859, CraftVault.class, CraftVault::new);
    }

    private static class BlockEntityStateFactory<T extends class_2586, B extends CardboardBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final class_2591<? extends T> tileEntityConstructor;
        private final class_2591<? extends T> blockEntityType;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, class_2591<? extends T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
            this.blockEntityType = tileEntityConstructor;
        }

        private T createBlockEntity(class_2338 pos, class_2680 state) {
            return (T)this.blockEntityType.method_11032(pos, state);
        }

        @Override
        public final B createBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(class_2338 blockPosition, class_2680 blockData) {
            return (T)this.tileEntityConstructor.method_11032(blockPosition, blockData);
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CardboardBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, class_2338 var2, class_2680 var3, class_2586 var4);
    }
}

