/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2509;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.util.CraftLegacy;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.cardboardpowered.impl.world.CraftWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftItemFactory
implements ItemFactory {
    private static final class_5819 randomSource = class_5819.method_43047();
    protected static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB((int)10511680);
    protected static final Collection<String> KNOWN_NBT_ATTRIBUTE_NAMES;
    private static final CraftItemFactory instance;

    private CraftItemFactory() {
    }

    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        return itemstack == null ? false : this.isApplicable(meta, itemstack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException(meta.getClass().toString() + "'s meta not created by " + CraftItemFactory.class.getName());
        }
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    public ItemMeta getItemMeta(Material material) {
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        material = CraftLegacy.fromLegacy(material);
        switch (material) {
            case AIR: {
                return null;
            }
            case WRITTEN_BOOK: {
                return meta instanceof CraftMetaBookSigned ? meta : new CraftMetaBookSigned(meta);
            }
            case WRITABLE_BOOK: {
                return meta != null && meta.getClass().equals(CraftMetaBook.class) ? meta : new CraftMetaBook(meta);
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: 
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return meta instanceof CraftMetaSkull ? meta : new CraftMetaSkull(meta);
            }
            case LEATHER_HELMET: 
            case LEATHER_HORSE_ARMOR: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return meta instanceof CraftMetaLeatherArmor ? meta : new CraftMetaLeatherArmor(meta);
            }
            case POTION: 
            case SPLASH_POTION: 
            case LINGERING_POTION: 
            case TIPPED_ARROW: {
                return meta instanceof CraftMetaPotion ? meta : new CraftMetaPotion(meta);
            }
            case FILLED_MAP: {
                return meta instanceof CraftMetaMap ? meta : new CraftMetaMap(meta);
            }
            case FIREWORK_ROCKET: {
                return meta instanceof CraftMetaFirework ? meta : new CraftMetaFirework(meta);
            }
            case FIREWORK_STAR: {
                return meta instanceof CraftMetaCharge ? meta : new CraftMetaCharge(meta);
            }
            case ENCHANTED_BOOK: {
                return meta instanceof CraftMetaEnchantedBook ? meta : new CraftMetaEnchantedBook(meta);
            }
            case BLACK_BANNER: 
            case BLACK_WALL_BANNER: 
            case BLUE_BANNER: 
            case BLUE_WALL_BANNER: 
            case BROWN_BANNER: 
            case BROWN_WALL_BANNER: 
            case CYAN_BANNER: 
            case CYAN_WALL_BANNER: 
            case GRAY_BANNER: 
            case GRAY_WALL_BANNER: 
            case GREEN_BANNER: 
            case GREEN_WALL_BANNER: 
            case LIGHT_BLUE_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: 
            case LIGHT_GRAY_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: 
            case LIME_BANNER: 
            case LIME_WALL_BANNER: 
            case MAGENTA_BANNER: 
            case MAGENTA_WALL_BANNER: 
            case ORANGE_BANNER: 
            case ORANGE_WALL_BANNER: 
            case PINK_BANNER: 
            case PINK_WALL_BANNER: 
            case PURPLE_BANNER: 
            case PURPLE_WALL_BANNER: 
            case RED_BANNER: 
            case RED_WALL_BANNER: 
            case WHITE_BANNER: 
            case WHITE_WALL_BANNER: 
            case YELLOW_BANNER: 
            case YELLOW_WALL_BANNER: {
                return meta instanceof CraftMetaBanner ? meta : new CraftMetaBanner(meta);
            }
            case BAT_SPAWN_EGG: 
            case BEE_SPAWN_EGG: 
            case BLAZE_SPAWN_EGG: 
            case CAT_SPAWN_EGG: 
            case CAVE_SPIDER_SPAWN_EGG: 
            case CHICKEN_SPAWN_EGG: 
            case COD_SPAWN_EGG: 
            case COW_SPAWN_EGG: 
            case CREEPER_SPAWN_EGG: 
            case DOLPHIN_SPAWN_EGG: 
            case DONKEY_SPAWN_EGG: 
            case DROWNED_SPAWN_EGG: 
            case ELDER_GUARDIAN_SPAWN_EGG: 
            case ENDERMAN_SPAWN_EGG: 
            case ENDERMITE_SPAWN_EGG: 
            case EVOKER_SPAWN_EGG: 
            case FOX_SPAWN_EGG: 
            case GHAST_SPAWN_EGG: 
            case GUARDIAN_SPAWN_EGG: 
            case HORSE_SPAWN_EGG: 
            case HUSK_SPAWN_EGG: 
            case LLAMA_SPAWN_EGG: 
            case MAGMA_CUBE_SPAWN_EGG: 
            case MOOSHROOM_SPAWN_EGG: 
            case MULE_SPAWN_EGG: 
            case OCELOT_SPAWN_EGG: 
            case PANDA_SPAWN_EGG: 
            case PARROT_SPAWN_EGG: 
            case PHANTOM_SPAWN_EGG: 
            case PIG_SPAWN_EGG: 
            case PILLAGER_SPAWN_EGG: 
            case POLAR_BEAR_SPAWN_EGG: 
            case PUFFERFISH_SPAWN_EGG: 
            case RABBIT_SPAWN_EGG: 
            case RAVAGER_SPAWN_EGG: 
            case SALMON_SPAWN_EGG: 
            case SHEEP_SPAWN_EGG: 
            case SHULKER_SPAWN_EGG: 
            case SILVERFISH_SPAWN_EGG: 
            case SKELETON_HORSE_SPAWN_EGG: 
            case SKELETON_SPAWN_EGG: 
            case SLIME_SPAWN_EGG: 
            case SPIDER_SPAWN_EGG: 
            case SQUID_SPAWN_EGG: 
            case STRAY_SPAWN_EGG: 
            case TRADER_LLAMA_SPAWN_EGG: 
            case TROPICAL_FISH_SPAWN_EGG: 
            case TURTLE_SPAWN_EGG: 
            case VEX_SPAWN_EGG: 
            case VILLAGER_SPAWN_EGG: 
            case VINDICATOR_SPAWN_EGG: 
            case WANDERING_TRADER_SPAWN_EGG: 
            case WITCH_SPAWN_EGG: 
            case WITHER_SKELETON_SPAWN_EGG: 
            case WOLF_SPAWN_EGG: 
            case ZOMBIE_HORSE_SPAWN_EGG: 
            case PIGLIN_SPAWN_EGG: 
            case ZOMBIE_SPAWN_EGG: 
            case ZOMBIE_VILLAGER_SPAWN_EGG: {
                return meta instanceof CraftMetaSpawnEgg ? meta : new CraftMetaSpawnEgg(meta);
            }
            case ARMOR_STAND: {
                return meta instanceof CraftMetaArmorStand ? meta : new CraftMetaArmorStand(meta);
            }
            case KNOWLEDGE_BOOK: {
                return meta instanceof CraftMetaKnowledgeBook ? meta : new CraftMetaKnowledgeBook(meta);
            }
            case FURNACE: 
            case CHEST: 
            case TRAPPED_CHEST: 
            case JUKEBOX: 
            case DISPENSER: 
            case DROPPER: 
            case ACACIA_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_SIGN: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case OAK_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case SPAWNER: 
            case BREWING_STAND: 
            case ENCHANTING_TABLE: 
            case COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: 
            case BEACON: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case COMPARATOR: 
            case SHIELD: 
            case STRUCTURE_BLOCK: 
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case ENDER_CHEST: 
            case BARREL: 
            case BELL: 
            case BLAST_FURNACE: 
            case CAMPFIRE: 
            case JIGSAW: 
            case LECTERN: 
            case SMOKER: 
            case BEEHIVE: 
            case BEE_NEST: {
                return new CraftMetaBlockState(meta, material);
            }
            case TROPICAL_FISH_BUCKET: 
            case CROSSBOW: {
                return meta instanceof CraftMetaCrossbow ? meta : new CraftMetaCrossbow(meta);
            }
            case SUSPICIOUS_STEW: {
                return meta instanceof CraftMetaSuspiciousStew ? meta : new CraftMetaSuspiciousStew(meta);
            }
        }
        return new CraftMetaItem(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 != null && !(meta1 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("First meta of " + meta1.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta2 != null && !(meta2 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Second meta " + meta2.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    public boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Validate.notNull(stack, "Stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Validate.notNull(material, "Material cannot be null");
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Meta of " + (meta != null ? meta.getClass().toString() : "null") + " not created by " + CraftItemFactory.class.getName());
        }
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    public Material updateMaterial(ItemMeta meta, Material material) throws IllegalArgumentException {
        return ((CraftMetaItem)meta).updateMaterial(material);
    }

    public ItemStack ensureServerConversions(ItemStack arg0) {
        return null;
    }

    public String getI18NDisplayName(ItemStack arg0) {
        return arg0.getType().name();
    }

    public Content hoverContentOf(ItemStack arg0) {
        return null;
    }

    public Content hoverContentOf(Entity arg0) {
        return null;
    }

    public Content hoverContentOf(Entity arg0, String arg1) {
        return null;
    }

    public Content hoverContentOf(Entity arg0, BaseComponent arg1) {
        return null;
    }

    public Content hoverContentOf(Entity arg0, BaseComponent[] arg1) {
        return null;
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull ItemStack arg0, @NotNull UnaryOperator<HoverEvent.ShowItem> arg1) {
        return null;
    }

    public Component displayName(@NotNull ItemStack arg0) {
        return null;
    }

    @Nullable
    public Material getSpawnEgg(EntityType arg0) {
        return null;
    }

    @NotNull
    public ItemStack createItemStack(@NotNull String arg0) throws IllegalArgumentException {
        return null;
    }

    public ItemStack enchantItem(Entity entity, ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(World world, ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(((CraftWorld)world).getHandle().field_9229, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    private static ItemStack enchantItem(class_5819 source, ItemStack itemStack, int level, boolean allowTreasures) {
        itemStack = CraftItemStack.asCraftCopy(itemStack);
        CraftItemStack craft = (CraftItemStack)itemStack;
        class_5455 registry = CraftRegistry.getMinecraftRegistry();
        Optional optional = allowTreasures ? Optional.empty() : registry.method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
        return CraftItemStack.asCraftMirror(class_1890.method_60133((class_5819)source, (class_1799)craft.handle, (int)level, (class_5455)registry, (Optional)optional));
    }

    public ItemStack enchantWithLevels(ItemStack itemStack, int levels, boolean allowTreasure, Random random) {
        return this.enchantWithLevels(itemStack, levels, allowTreasure ? Optional.empty() : CraftServer.server.method_30611().method_30530(class_7924.field_41265).method_46733(class_9636.field_51547), random);
    }

    public ItemStack enchantWithLevels(ItemStack itemStack, int levels, RegistryKeySet<Enchantment> keySet, Random random) {
        return this.enchantWithLevels(itemStack, levels, Optional.of(PaperRegistrySets.convertToNms(class_7924.field_41265, CraftServer.server.method_30611().method_57093((DynamicOps)class_2509.field_11560).field_40852, keySet)), random);
    }

    private ItemStack enchantWithLevels(ItemStack itemStack, int levels, Optional<? extends class_6885<class_1887>> possibleEnchantments, Random random) {
        class_1799 internalStack = CraftItemStack.asNMSCopy(itemStack);
        if (internalStack.method_7942()) {
            internalStack.method_57379(class_9334.field_49633, (Object)class_9304.field_49385);
        }
        class_5455.class_6890 registryAccess = CraftServer.server.method_30611();
        class_1799 enchanted = class_1890.method_60133((class_5819)new RandomSourceWrapper(random), (class_1799)internalStack, (int)levels, (class_5455)registryAccess, possibleEnchantments);
        return CraftItemStack.asCraftMirror(enchanted);
    }

    static {
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(CraftMetaItem.SerializableMeta.class);
        KNOWN_NBT_ATTRIBUTE_NAMES = ImmutableSet.builder().add((Object)"generic.armor").add((Object)"generic.armorToughness").add((Object)"generic.attackDamage").add((Object)"generic.followRange").add((Object)"generic.knockbackResistance").add((Object)"generic.maxHealth").add((Object)"generic.movementSpeed").add((Object)"generic.flyingSpeed").add((Object)"generic.attackSpeed").add((Object)"generic.luck").add((Object)"horse.jumpStrength").add((Object)"zombie.spawnReinforcements").add((Object)"generic.attackKnockback").build();
    }
}

