/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.papermc.paper.datacomponent.DataComponentType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_3962;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9895;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.inventory.CraftItemMetas;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinMinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CraftItemType<M extends ItemMeta>
implements ItemType.Typed<M>,
Handleable<class_1792> {
    private final NamespacedKey key;
    private final class_1792 item;
    private final Supplier<CraftItemMetas.ItemMetaData<M>> itemMetaData;

    public static Material minecraftToBukkit(class_1792 item) {
        return CraftMagicNumbers.getMaterial(item);
    }

    public static class_1792 bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getItem(material);
    }

    public static ItemType minecraftToBukkitNew(class_1792 minecraft) {
        return (ItemType)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41197);
    }

    public static class_1792 bukkitToMinecraftNew(ItemType bukkit) {
        return (class_1792)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftItemType(NamespacedKey key, class_1792 item) {
        this.key = key;
        this.item = item;
        this.itemMetaData = Suppliers.memoize(() -> CraftItemMetas.getItemMetaData(this));
    }

    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        return this.typed(ItemMeta.class);
    }

    @NotNull
    public <Other extends ItemMeta> ItemType.Typed<Other> typed(@NotNull Class<Other> itemMetaType) {
        if (itemMetaType.isAssignableFrom(this.itemMetaData.get().metaClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type item type " + this.key.toString() + " to meta type " + itemMetaType.getSimpleName());
    }

    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1, null);
    }

    @NotNull
    public ItemStack createItemStack(int amount) {
        return this.createItemStack(amount, null);
    }

    @NotNull
    public ItemStack createItemStack(Consumer<? super M> metaConfigurator) {
        return this.createItemStack(1, metaConfigurator);
    }

    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        class_1799 stack = new class_1799((class_1935)this.item, amount);
        CraftItemStack mirror = CraftItemStack.asCraftMirror(stack);
        if (metaConfigurator != null) {
            mirror.editMeta(this.getItemMetaClass(), metaConfigurator);
        }
        return mirror;
    }

    @Override
    public class_1792 getHandle() {
        return this.item;
    }

    public boolean hasBlockType() {
        return this.item instanceof class_1747;
    }

    @NotNull
    public BlockType getBlockType() {
        class_1792 item = this.item;
        if (!(item instanceof class_1747)) {
            throw new IllegalStateException("The item type " + String.valueOf(this.getKey()) + " has no corresponding block type");
        }
        class_1747 block = (class_1747)item;
        return CraftBlockType.minecraftToBukkitNew(block.method_7711());
    }

    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.itemMetaData.get().metaClass();
    }

    public int getMaxStackSize() {
        if (this == AIR) {
            return 0;
        }
        return (Integer)this.item.method_57347().method_58695(class_9334.field_50071, (Object)64);
    }

    public short getMaxDurability() {
        return ((Integer)this.item.method_57347().method_58695(class_9334.field_50072, (Object)0)).shortValue();
    }

    public boolean isEdible() {
        return this.item.method_57347().method_57832(class_9334.field_50075);
    }

    public boolean isRecord() {
        return this.item.method_57347().method_57832(class_9334.field_52175);
    }

    public boolean isFuel() {
        return IMixinMinecraftServer.getServer().method_62735().method_61752(new class_1799((class_1935)this.item));
    }

    public boolean isCompostable() {
        return class_3962.field_17566.containsKey((Object)this.item);
    }

    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.getKey()) + " is not compostable"));
        return class_3962.field_17566.getFloat((Object)this.item);
    }

    public ItemType getCraftingRemainingItem() {
        class_1799 expectedItem = this.item.method_7858();
        return expectedItem.method_7960() ? null : CraftItemType.minecraftToBukkitNew(expectedItem.method_7909());
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers() {
        return this.getDefaultAttributeModifiers((class_9274 sg) -> true);
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        class_1304 nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getDefaultAttributeModifiers((class_9274 sg) -> sg.method_57286(nmsSlot));
    }

    private Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Predicate<class_9274> slotPredicate) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        class_9285 nmsDefaultAttributes = (class_9285)this.item.method_57347().method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : nmsDefaultAttributes.comp_2393()) {
            if (!slotPredicate.test(entry.comp_2397())) continue;
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit((class_6880<class_1320>)entry.comp_2395());
            AttributeModifier modifier = CraftAttributeInstance.convert(entry.comp_2396(), entry.comp_2397());
            defaultAttributes.put((Object)attribute, (Object)modifier);
        }
        return defaultAttributes.build();
    }

    public CreativeCategory getCreativeCategory() {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return this.getHandle().method_45382(((CraftWorld)world).getHandle().method_45162());
    }

    @NotNull
    public String getTranslationKey() {
        return this.item.method_7876();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.key);
    }

    public String translationKey() {
        return this.item.method_7876();
    }

    public ItemRarity getItemRarity() {
        class_1814 rarity = (class_1814)this.item.method_57347().method_58694(class_9334.field_50073);
        return rarity == null ? null : ItemRarity.valueOf((String)rarity.name());
    }

    @Nullable
    public <T> T getDefaultData(@NotNull DataComponentType.Valued<T> type) {
        return null;
    }

    public boolean hasDefaultData(@NotNull DataComponentType type) {
        return this.item.method_57347().method_57832(CraftItemType.PaperDataComponentType_bukkitToMinecraft(type));
    }

    public @Unmodifiable @NotNull Set<DataComponentType> getDefaultDataTypes() {
        return CraftItemType.PaperDataComponentType_minecraftToBukkit(this.item.method_57347().method_57831());
    }

    public static <T> class_9331<T> PaperDataComponentType_bukkitToMinecraft(DataComponentType type) {
        return (class_9331)CraftRegistry.bukkitToMinecraft(type);
    }

    public static DataComponentType PaperDataComponentType_minecraftToBukkit(class_9331<?> type) {
        return (DataComponentType)CraftRegistry.minecraftToBukkit(type, class_7924.field_49659);
    }

    public static Set<DataComponentType> PaperDataComponentType_minecraftToBukkit(Set<class_9331<?>> nmsTypes) {
        HashSet<DataComponentType> types = new HashSet<DataComponentType>(nmsTypes.size());
        for (class_9331<?> nmsType : nmsTypes) {
            types.add(CraftItemType.PaperDataComponentType_minecraftToBukkit(nmsType));
        }
        return Collections.unmodifiableSet(types);
    }

    public int getBurnDuration() {
        class_1799 stack;
        class_9895 fuelValues = CraftServer.server.method_62735();
        if (!fuelValues.method_61752(stack = new class_1799((class_1935)this.getHandle()))) {
            return 0;
        }
        return fuelValues.method_61755(stack);
    }
}

