/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_11580;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9336;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.util.BlockVector;
import org.cardboardpowered.TypedEntityDataExtra;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.interfaces.IComponentChanges;
import org.cardboardpowered.interfaces.IMixinBlockEntity;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    static final CraftMetaItem.ItemMetaKeyType<class_11580<class_2591<?>>> BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49611, "BlockEntityTag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG_CUSTOM_DATA = new CraftMetaItem.ItemMetaKey("block-entity-tag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_COMPONENTS = new CraftMetaItem.ItemMetaKey("block-entity-components");
    private static final class_2487 EMPTY_TAG = new class_2487();
    final Material material;
    class_9323 components;
    class_2487 blockEntityTag;
    private class_2487 internalTag;

    public static class_11362 NbtWriteView_createWrappingWithContext(class_8942.class_11340 problemReporter, class_5455 lookup, class_2487 compoundTag) {
        return new class_11362((class_8942)problemReporter, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), compoundTag);
    }

    private Material materialForBlockEntityType() {
        return this.material;
    }

    /*
     * Enabled aggressive block sorting
     */
    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.components = this.components != null ? this.components : class_9323.field_49584;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : EMPTY_TAG;
        this.material = material;
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState metaBlockState = (CraftMetaBlockState)meta;
            if (metaBlockState.material == material) {
                this.components = metaBlockState.components;
                this.blockEntityTag = metaBlockState.blockEntityTag;
                return;
            }
        }
        this.components = class_9323.field_49584;
        this.blockEntityTag = EMPTY_TAG;
    }

    CraftMetaBlockState(class_9326 tag, Material material, Set<class_9331<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        this.components = this.components != null ? this.components : class_9323.field_49584;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : EMPTY_TAG;
        this.material = material;
        this.updateBlockState(tag);
    }

    private void updateBlockState(class_9326 tag) {
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(nbt -> {
            this.blockEntityTag = TypedEntityDataExtra.copyTagWithBlockEntityId(nbt);
        });
        if (!tag.method_57848()) {
            class_9323.class_9324 map = class_9323.method_57827();
            class_2586 dummyBlockEntity = Objects.requireNonNull(CraftBlockStates.createNewBlockEntity(this.materialForBlockEntityType()));
            Set<class_9331<?>> applied = ((IMixinBlockEntity)dummyBlockEntity).applyComponentsSet(class_9323.field_49584, class_9326.field_49588);
            for (class_9331<?> seen : applied) {
                ((IComponentChanges)this.unhandledTags).clear(seen);
            }
            if (!applied.isEmpty()) {
                for (class_9331<?> type : applied) {
                    if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(type)) continue;
                    CraftMetaBlockState.getOrEmpty(tag, type).ifPresent(value -> map.method_57840(type, value));
                }
            }
            this.components = map.method_57838();
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        BlockVector legacyPosition;
        this.components = this.components != null ? this.components : class_9323.field_49584;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : EMPTY_TAG;
        String blockMaterial = CraftMetaItem.SerializableMeta.getString(map, "blockMaterial", true);
        Material material = Material.getMaterial((String)blockMaterial);
        Material material2 = this.material = material != null ? material : Material.AIR;
        if (this.internalTag != null) {
            this.setBlockState(CraftMetaBlockState.getBlockState(this.material, this.internalTag));
            this.internalTag = null;
        }
        if ((legacyPosition = CraftMetaItem.SerializableMeta.getObject(BlockVector.class, map, "blockPosition", true)) != null) {
            class_2487 blockEntityTag = this.blockEntityTag.method_10553();
            try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "blockEntityTag", CraftMetaItem.LOGGER);){
                class_11362 output = CraftMetaBlockState.NbtWriteView_createWrappingWithContext(problemReporter, CraftRegistry.getMinecraftRegistry(), blockEntityTag);
                if (blockEntityTag.method_33133()) {
                    class_2586.method_38238((class_11372)output, Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
                }
                output.method_71465("x", legacyPosition.getBlockX());
                output.method_71465("y", legacyPosition.getBlockY());
                output.method_71465("z", legacyPosition.getBlockZ());
            }
            this.blockEntityTag = blockEntityTag;
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        class_2487 nbt = this.blockEntityTag.method_10553();
        if (!nbt.method_33133()) {
            if (nbt.method_10558("id").isEmpty()) {
                try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "CraftMetaBlockState#apply", CraftMetaItem.LOGGER);){
                    class_2586.method_38238((class_11372)CraftMetaBlockState.NbtWriteView_createWrappingWithContext(problemReporter, CraftRegistry.getMinecraftRegistry(), nbt), Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
                }
            }
            tag.put(BLOCK_ENTITY_TAG, TypedEntityDataExtra.decodeBlockEntity(nbt));
        }
        for (class_9336 component : this.components) {
            if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(component.comp_2443())) continue;
            tag.builder.method_57855(component);
        }
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        super.deserializeInternal(tag, context);
        Optional blockEntityTag = tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        if (blockEntityTag.isPresent()) {
            this.internalTag = (class_2487)blockEntityTag.get();
        } else {
            tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT).ifPresent(blockEntityCustomTag -> {
                this.blockEntityTag = blockEntityCustomTag.method_10553();
            });
            tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT).ifPresent(components -> {
                this.components = (class_9323)class_9323.field_50234.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), components).getOrThrow();
            });
        }
    }

    @Override
    void serializeInternal(Map<String, class_2520> internalTags) {
        if (!this.blockEntityTag.method_33133()) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT, (class_2520)this.blockEntityTag);
        }
        if (!this.components.method_57837()) {
            class_2520 componentsTag = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), (Object)this.components).getOrThrow();
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT, componentsTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        hash = 61 * hash + this.blockEntityTag.hashCode();
        return original != (hash = 61 * hash + this.components.hashCode()) ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        boolean bl;
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (!(meta instanceof CraftMetaBlockState)) {
            bl = true;
        } else {
            CraftMetaBlockState other = (CraftMetaBlockState)meta;
            bl = Objects.equals(this.blockEntityTag, other.blockEntityTag) && Objects.equals(this.components, other.components);
        }
        return bl;
    }

    boolean isBlockStateEmpty() {
        return this.blockEntityTag == null;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag.method_33133() && this.components.method_57837());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag.method_33133() && this.components.method_57837();
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        meta.blockEntityTag = this.blockEntityTag;
        meta.components = this.components;
        return meta;
    }

    public boolean hasBlockState() {
        return !this.blockEntityTag.method_33133() || !this.components.method_57837();
    }

    public void clearBlockState() {
        this.blockEntityTag = EMPTY_TAG;
        this.components = class_9323.field_49584;
    }

    public CardboardBlockEntityState<?> getBlockState() {
        class_2338 pos = class_2338.field_10980;
        Material stateMaterial = this.materialForBlockEntityType();
        if (!this.blockEntityTag.method_33133()) {
            pos = class_2586.method_38239(null, (class_2487)this.blockEntityTag);
        }
        class_2591<?> type = Objects.requireNonNull(CraftBlockStates.getBlockEntityType(stateMaterial));
        class_2680 nmsBlockState = ((CraftBlockData)this.getBlockData(stateMaterial)).getState();
        class_2586 blockEntity = Objects.requireNonNull(type.method_11032(pos, nmsBlockState));
        if (!this.blockEntityTag.method_33133()) {
            TypedEntityDataExtra.decodeBlockEntity(this.blockEntityTag).method_72534(blockEntity, (class_7225.class_7874)CraftRegistry.getMinecraftRegistry());
        }
        class_9335 patchedMap = new class_9335(nmsBlockState.method_26204().method_8389().method_57347());
        patchedMap.method_57933(this.components);
        CraftMetaItem.Applicator applicator = new CraftMetaItem.Applicator(this){};
        super.applyToItem(applicator);
        patchedMap.method_57936(applicator.build());
        blockEntity.method_58685(nmsBlockState.method_26204().method_8389().method_57347(), patchedMap.method_57940());
        return (CardboardBlockEntityState)CraftBlockStates.getBlockState(null, pos, nmsBlockState, blockEntity);
    }

    private static CardboardBlockEntityState<?> getBlockState(Material material, class_2487 blockEntityTag) {
        Material stateMaterial;
        class_2338 pos = class_2338.field_10980;
        Material material2 = stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack(blockEntityTag);
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.method_10582("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.method_10582("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.method_10582("id", "minecraft:shulker_box");
            }
            pos = class_2586.method_38239(null, (class_2487)blockEntityTag);
        }
        return (CardboardBlockEntityState)CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), pos, stateMaterial, blockEntityTag);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(null);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CardboardBlockEntityState ? 1 : 0) != 0, (String)"Invalid blockState for %s", (Object)this.material);
        CardboardBlockEntityState craftBlockState = (CardboardBlockEntityState)blockState;
        class_2487 data = craftBlockState.getSnapshotCustomNbtOnly();
        class_9335 patchedMap = new class_9335(craftBlockState.getHandle().method_26204().method_8389().method_57347());
        class_9323 map = craftBlockState.collectComponents();
        patchedMap.method_57933(map);
        if (!data.method_33133()) {
            patchedMap.method_57938(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, TypedEntityDataExtra.decodeBlockEntity(data));
        }
        class_9326 patch = patchedMap.method_57940();
        this.updateFromPatch(patch, null);
        this.blockEntityTag = EMPTY_TAG;
        this.components = class_9323.field_49584;
        this.updateBlockState(patch);
    }

    private static Material shieldToBannerHack(class_2487 tag) {
        Optional baseColor;
        if (tag != null && (baseColor = tag.method_10562("components").flatMap(components -> components.method_10558("minecraft:base_color"))).isPresent()) {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)class_1767.method_7793((String)((String)baseColor.get()), (class_1767)class_1767.field_7952).method_7789()));
            return CraftMetaShield.shieldToBannerHack(color);
        }
        return Material.WHITE_BANNER;
    }
}

