/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_10191;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.cardboardpowered.impl.tag.CraftEntityTag;

@SerializableAs(value="Equippable")
public final class CraftEquippableComponent
implements EquippableComponent {
    private class_10192 handle;

    public CraftEquippableComponent(class_10192 handle) {
        this.handle = handle;
    }

    public CraftEquippableComponent(CraftEquippableComponent craft) {
        this.handle = craft.handle;
    }

    public CraftEquippableComponent(Map<String, Object> map) {
        class_1304 slot = CraftEquipmentSlot.getNMS(EquipmentSlot.valueOf((String)SerializableMeta.getString(map, "slot", false)));
        Sound equipSound = null;
        String equipSoundKey = SerializableMeta.getString(map, "equip-sound", true);
        if (equipSoundKey != null) {
            equipSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)equipSoundKey));
        }
        String model = SerializableMeta.getString(map, "model", true);
        String cameraOverlay = SerializableMeta.getString(map, "camera-overlay", true);
        class_6885 allowedEntities = null;
        Object allowed = SerializableMeta.getObject(Object.class, map, "allowed-entities", true);
        if (allowed != null) {
            allowedEntities = ConfigSerializationUtil.getHolderSet(allowed, class_7924.field_41266);
        }
        Boolean dispensable = SerializableMeta.getObject(Boolean.class, map, "dispensable", true);
        Boolean swappable = SerializableMeta.getObject(Boolean.class, map, "swappable", true);
        Boolean damageOnHurt = SerializableMeta.getObject(Boolean.class, map, "damage-on-hurt", true);
        Boolean equipOnInteract = SerializableMeta.getObject(Boolean.class, map, "equip-on-interact", true);
        this.handle = new class_10192(slot, equipSound != null ? CraftSound.bukkitToMinecraftHolder(equipSound) : class_3417.field_14883, Optional.ofNullable(model).map(class_2960::method_60654).map(k -> class_5321.method_29179((class_5321)class_10191.field_55214, (class_2960)k)), Optional.ofNullable(cameraOverlay).map(class_2960::method_60654), Optional.ofNullable(allowedEntities), dispensable != null ? dispensable : true, swappable != null ? swappable : true, damageOnHurt != null ? damageOnHurt : true, equipOnInteract != null ? equipOnInteract : false, false, class_7923.field_41172.method_47983((Object)class_3417.field_59992));
    }

    public Map<String, Object> serialize() {
        NamespacedKey cameraOverlay;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("slot", this.getSlot().name());
        result.put("equip-sound", Registry.SOUND_EVENT.getKeyOrThrow((Keyed)this.getEquipSound()).toString());
        NamespacedKey model = this.getModel();
        if (model != null) {
            result.put("model", model.toString());
        }
        if ((cameraOverlay = this.getCameraOverlay()) != null) {
            result.put("camera-overlay", cameraOverlay.toString());
        }
        this.handle.comp_3177().ifPresent(holders -> ConfigSerializationUtil.setHolderSet(result, "allowed-entities", holders));
        result.put("dispensable", this.isDispensable());
        result.put("swappable", this.isSwappable());
        result.put("damage-on-hurt", this.isDamageOnHurt());
        result.put("equip-on-interact", this.isEquipOnInteract());
        return result;
    }

    public class_10192 getHandle() {
        return this.handle;
    }

    public EquipmentSlot getSlot() {
        return CraftEquipmentSlot.getSlot(this.handle.comp_3174());
    }

    public void setSlot(EquipmentSlot slot) {
        this.handle = new class_10192(CraftEquipmentSlot.getNMS(slot), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public Sound getEquipSound() {
        return CraftSound.minecraftToBukkit((class_3414)this.handle.comp_3175().comp_349());
    }

    public void setEquipSound(Sound sound) {
        this.handle = new class_10192(this.handle.comp_3174(), sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : class_3417.field_14883, this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public NamespacedKey getModel() {
        return this.handle.comp_3176().map(a2 -> CraftNamespacedKey.fromMinecraft(a2.method_29177())).orElse(null);
    }

    public void setModel(NamespacedKey key) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft).map(k -> class_5321.method_29179((class_5321)class_10191.field_55214, (class_2960)k)), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public NamespacedKey getCameraOverlay() {
        return this.handle.comp_3306().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCameraOverlay(NamespacedKey key) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public Collection<EntityType> getAllowedEntities() {
        return this.handle.comp_3177().map(class_6885::method_40239).map(stream -> stream.map(class_6880::comp_349).map(CraftEntityType::minecraftToBukkit).collect(Collectors.toList())).orElse(null);
    }

    public void setAllowedEntities(EntityType entities) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), entities != null ? Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{CraftEntityType.bukkitToMinecraftHolder(entities)})) : Optional.empty(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public void setAllowedEntities(Collection<EntityType> entities) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), entities != null ? Optional.of(class_6885.method_40242(entities.stream().map(CraftEntityType::bukkitToMinecraftHolder).collect(Collectors.toList()))) : Optional.empty(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public void setAllowedEntities(Tag<EntityType> tag) {
        Preconditions.checkArgument((tag == null || tag instanceof CraftEntityTag ? 1 : 0) != 0, (Object)"tag must be an entity tag");
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), tag != null ? Optional.of(((CraftEntityTag)tag).getHandle()) : Optional.empty(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public boolean isDispensable() {
        return this.handle.comp_3178();
    }

    public void setDispensable(boolean dispensable) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), dispensable, this.handle.comp_3213(), this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public boolean isSwappable() {
        return this.handle.comp_3213();
    }

    public void setSwappable(boolean swappable) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), swappable, this.handle.comp_3214(), this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public boolean isDamageOnHurt() {
        return this.handle.comp_3214();
    }

    public void setDamageOnHurt(boolean damage) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), damage, this.handle.comp_3523(), this.handle.comp_4362(), this.handle.comp_4363());
    }

    public boolean isEquipOnInteract() {
        return this.handle.comp_3523();
    }

    public void setEquipOnInteract(boolean equip) {
        this.handle = new class_10192(this.handle.comp_3174(), this.handle.comp_3175(), this.handle.comp_3176(), this.handle.comp_3306(), this.handle.comp_3177(), this.handle.comp_3178(), this.handle.comp_3213(), this.handle.comp_3214(), equip, this.handle.comp_4362(), this.handle.comp_4363());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEquippableComponent other = (CraftEquippableComponent)obj;
        return this.handle.equals((Object)other.handle);
    }

    public String toString() {
        return "CraftEquippableComponent{component" + String.valueOf(this.handle) + "}";
    }
}

