/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_268;
import net.minecraft.class_270;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboard;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardComponent;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardTeam
extends CardboardScoreboardComponent
implements Team {
    private final class_268 team;

    CardboardTeam(CardboardScoreboard scoreboard, class_268 team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return this.team.method_1197();
    }

    public String getDisplayName() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1140());
    }

    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull(displayName, "Display name cannot be null");
        Validate.isTrue(ChatColor.stripColor((String)displayName).length() <= 128, "Display name '" + displayName + "' is longer than the limit of 128 characters");
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1137(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1144());
    }

    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(prefix, "Prefix cannot be null");
        Validate.isTrue(ChatColor.stripColor((String)prefix).length() <= 64, "Prefix '" + prefix + "' is longer than the limit of 64 characters");
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1138(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1136());
    }

    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(suffix, "Suffix cannot be null");
        Validate.isTrue(ChatColor.stripColor((String)suffix).length() <= 64, "Suffix '" + suffix + "' is longer than the limit of 64 characters");
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1139(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return CraftChatMessage.getColor(this.team.method_1202());
    }

    public void setColor(ChatColor color) {
        Validate.notNull(color, "Color cannot be null");
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1141(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return this.team.method_1205();
    }

    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1135(enabled);
    }

    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return this.team.method_1199();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1143(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        CardboardScoreboard scoreboard = this.checkState();
        return CardboardTeam.notchToBukkit(this.team.method_1201());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        CardboardScoreboard scoreboard = this.checkState();
        this.team.method_1149(CardboardTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.method_1204()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.method_1204()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return this.team.method_1204().size();
    }

    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null");
        CardboardScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1172(entry, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null");
        CardboardScoreboard scoreboard = this.checkState();
        if (!this.team.method_1204().contains(entry)) {
            return false;
        }
        scoreboard.board.method_1157(entry, this.team);
        return true;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull("Entry cannot be null");
        CardboardScoreboard scoreboard = this.checkState();
        return this.team.method_1204().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1191(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.method_1201().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.method_1200().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.method_1203().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
    }

    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.method_1149(class_270.class_272.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.method_1133(class_270.class_272.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.method_1145(class_270.class_271.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
            }
        }
    }

    public static class_270.class_272 bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return class_270.class_272.field_1442;
            }
            case NEVER: {
                return class_270.class_272.field_1443;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return class_270.class_272.field_1444;
            }
            case HIDE_FOR_OWN_TEAM: {
                return class_270.class_272.field_1446;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    public static NameTagVisibility notchToBukkit(class_270.class_272 visibility) {
        switch (visibility) {
            case field_1442: {
                return NameTagVisibility.ALWAYS;
            }
            case field_1443: {
                return NameTagVisibility.NEVER;
            }
            case field_1444: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case field_1446: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    @Override
    CardboardScoreboard checkState() throws IllegalStateException {
        if (this.getScoreboard().board.method_1153(this.team.method_1197()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CardboardTeam other = (CardboardTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }

    @NotNull
    public TextColor color() throws IllegalStateException {
        return null;
    }

    public void color(@Nullable NamedTextColor arg0) {
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        return null;
    }

    public void displayName(@Nullable Component arg0) throws IllegalStateException, IllegalArgumentException {
    }

    @NotNull
    public Component prefix() throws IllegalStateException {
        return null;
    }

    public void prefix(@Nullable Component arg0) throws IllegalStateException, IllegalArgumentException {
    }

    @NotNull
    public Component suffix() throws IllegalStateException {
        return null;
    }

    public void suffix(@Nullable Component arg0) throws IllegalStateException, IllegalArgumentException {
    }

    public void addEntities(@NotNull Collection<Entity> arg0) throws IllegalStateException, IllegalArgumentException {
    }

    public void addEntity(@NotNull Entity arg0) throws IllegalStateException, IllegalArgumentException {
    }

    public void addEntries(@NotNull Collection<String> arg0) throws IllegalStateException, IllegalArgumentException {
    }

    public boolean hasColor() {
        return false;
    }

    public boolean hasEntity(@NotNull Entity arg0) throws IllegalStateException, IllegalArgumentException {
        return false;
    }

    public boolean removeEntities(@NotNull Collection<Entity> arg0) throws IllegalStateException, IllegalArgumentException {
        return false;
    }

    public boolean removeEntity(@NotNull Entity arg0) throws IllegalStateException, IllegalArgumentException {
        return false;
    }

    public boolean removeEntries(@NotNull Collection<String> arg0) throws IllegalStateException, IllegalArgumentException {
        return false;
    }

    public Iterable<? extends Audience> audiences() {
        this.checkState();
        ArrayList<Player> audiences = new ArrayList<Player>();
        for (String playerName : this.team.method_1204()) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) continue;
            audiences.add(player);
        }
        return audiences;
    }
}

