/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.interfaces.IMixinSignBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardSign<T extends class_2625>
extends CardboardBlockEntityState<T>
implements Sign {
    private String[] lines;
    private boolean editable;

    public CardboardSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CardboardSign(CardboardSign<T> state, Location location) {
        super(state, location);
    }

    @Override
    public void load(T sign) {
        super.load(sign);
        this.lines = new String[((IMixinSignBlockEntity)sign).getTextBF().length];
        System.arraycopy(CardboardSign.revertComponents(((IMixinSignBlockEntity)sign).getTextBF()), 0, this.lines, 0, this.lines.length);
    }

    public String[] getLines() {
        return this.lines;
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((byte)((class_2625)this.getSnapshot()).method_49853().method_49872().method_7789()));
    }

    public void setColor(DyeColor color) {
        ((class_2625)this.getSnapshot()).method_49853().method_49862(class_1767.method_7791((int)color.getWoolData()));
    }

    @Override
    public void applyTo(T sign) {
        super.applyTo(sign);
        class_2561[] newLines = CardboardSign.sanitizeLines(this.lines);
        System.arraycopy(newLines, 0, ((IMixinSignBlockEntity)sign).getTextBF(), 0, 4);
    }

    public static class_2561[] sanitizeLines(String[] lines) {
        class_2561[] components = new class_2561[4];
        for (int i = 0; i < 4; ++i) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : class_2561.method_30163((String)"");
        }
        return components;
    }

    public static String[] revertComponents(class_2561[] components) {
        String[] lines = new String[components.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CraftChatMessage.fromComponent(components[i]);
        }
        return lines;
    }

    public Component line(int arg0) throws IndexOutOfBoundsException {
        return null;
    }

    public void line(int arg0, @NotNull Component arg1) throws IndexOutOfBoundsException {
    }

    public List<Component> lines() {
        return null;
    }

    public boolean isGlowingText() {
        return ((class_2625)this.getSnapshot()).method_49853().method_49856();
    }

    public void setGlowingText(boolean arg0) {
        ((class_2625)this.getSnapshot()).method_49853().method_49867(arg0);
    }

    public SignSide getSide(Side side) {
        switch (side) {
            // Empty switch
        }
        return null;
    }

    @Override
    public CardboardSign<T> copy() {
        return new CardboardSign<T>(this, null);
    }

    @Override
    public CardboardSign<T> copy(Location location) {
        return new CardboardSign<T>(this, location);
    }

    public boolean isWaxed() {
        return ((class_2625)this.getSnapshot()).method_49855();
    }

    public void setWaxed(boolean waxed) {
        ((class_2625)this.getSnapshot()).method_49849(waxed);
    }

    public Side getInteractableSideFor(double x, double z) {
        this.requirePlaced();
        return ((IMixinSignBlockEntity)((class_2625)this.getSnapshot())).cardboard$isFacingFrontText(x, z) ? Side.FRONT : Side.BACK;
    }

    public static void openSign(Sign sign, Player player, Side side) {
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(player, sign, side, PlayerOpenSignEvent.Cause.PLUGIN);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0 && !CraftEventFactory.callPlayerSignOpenEvent(player, sign, side, PlayerSignOpenEvent.Cause.PLUGIN)) {
            return;
        }
        class_2625 handle = (class_2625)((CardboardSign)sign).getTileEntity();
        handle.method_11306(player.getUniqueId());
        ((CraftPlayer)player).getHandle().method_7311(handle, Side.FRONT == side);
    }

    @NotNull
    public SignSide getTargetSide(@NotNull Player player) {
        return null;
    }

    @Nullable
    public Player getAllowedEditor() {
        UUID id = ((class_2625)this.getTileEntity()).method_11305();
        return id == null ? null : Bukkit.getPlayer((UUID)id);
    }

    public UUID getAllowedEditorUniqueId() {
        return ((class_2625)this.getTileEntity()).method_11305();
    }

    public void setAllowedEditorUniqueId(UUID uuid) {
        ((class_2625)this.getTileEntity()).method_11306(uuid);
    }
}

