/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.cardboardpowered.impl.entity.CraftMonster;
import org.cardboardpowered.interfaces.ICreeperEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreeperImpl
extends CraftMonster
implements Creeper {
    public CreeperImpl(CraftServer server, class_1548 entity) {
        super(server, (class_1588)entity);
    }

    public boolean isPowered() {
        return ((ICreeperEntity)this.getHandle()).isPoweredBF();
    }

    public void setPowered(boolean powered) {
        CraftServer server = this.server;
        Creeper entity = (Creeper)this.getHandle().getBukkitEntity();
        if (powered) {
            CreeperPowerEvent event = new CreeperPowerEvent(entity, CreeperPowerEvent.PowerCause.SET_ON);
            server.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                ((ICreeperEntity)this.getHandle()).setPowered(true);
            }
        } else {
            CreeperPowerEvent event = new CreeperPowerEvent(entity, CreeperPowerEvent.PowerCause.SET_OFF);
            server.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                ((ICreeperEntity)this.getHandle()).setPowered(false);
            }
        }
    }

    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        ((ICreeperEntity)this.getHandle()).setFuseTimeBF(ticks);
    }

    public int getMaxFuseTicks() {
        return ((ICreeperEntity)this.getHandle()).getFuseTimeBF();
    }

    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"radius < 0");
        ((ICreeperEntity)this.getHandle()).setExplosionRadiusBF(radius);
    }

    public int getExplosionRadius() {
        return ((ICreeperEntity)this.getHandle()).getExplosionRadiusBF();
    }

    public void explode() {
        ((ICreeperEntity)this.getHandle()).explodeBF();
    }

    public void ignite() {
        this.getHandle().method_7004();
    }

    public class_1548 getHandle() {
        return (class_1548)this.nms;
    }

    @Override
    public String toString() {
        return "Creeper";
    }

    @Override
    public EntityType getType() {
        return EntityType.CREEPER;
    }

    public int getFuseTicks() {
        return 0;
    }

    public boolean isIgnited() {
        return false;
    }

    public void setIgnited(boolean arg0) {
    }

    @Override
    public int getHeadRotationSpeed() {
        return 0;
    }

    @Override
    public int getMaxHeadPitch() {
        return 0;
    }

    @Override
    public void lookAt(@NotNull Location arg0) {
    }

    @Override
    public void lookAt(@NotNull Entity arg0) {
    }

    @Override
    public void lookAt(@NotNull Location arg0, float arg1, float arg2) {
    }

    @Override
    public void lookAt(@NotNull Entity arg0, float arg1, float arg2) {
    }

    @Override
    public void lookAt(double arg0, double arg1, double arg2) {
    }

    @Override
    public void lookAt(double arg0, double arg1, double arg2, float arg3, float arg4) {
    }

    public void setFuseTicks(int arg0) {
    }

    public void ignite(@NotNull Entity entity) {
        this.getHandle().method_7004();
    }

    @Nullable
    public Entity getIgniter() {
        return null;
    }
}

