/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.world;

import java.util.HashSet;
import java.util.Set;
import me.isaiah.common.ICommonMod;
import me.isaiah.common.cmixin.IMixinMinecraftServer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import org.bukkit.HeightMap;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ChunkDataImpl
implements ChunkGenerator.ChunkData {
    private final int minHeight;
    private final int maxHeight;
    private final class_2826[] sections;
    private Set<class_2338> tiles;

    public ChunkDataImpl(World world) {
        this(world.getMinHeight(), world.getMaxHeight());
    }

    ChunkDataImpl(int min, int maxHeight) {
        if (maxHeight > 256) {
            throw new IllegalArgumentException("World height exceeded max chunk height");
        }
        this.minHeight = min;
        this.maxHeight = maxHeight;
        this.sections = new class_2826[maxHeight >> 4];
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setBlock(int x, int y, int z, Material material) {
        this.setBlock(x, y, z, material.createBlockData());
    }

    public void setBlock(int x, int y, int z, MaterialData material) {
        this.setBlock(x, y, z, CraftMagicNumbers.getBlock(material));
    }

    public void setBlock(int x, int y, int z, BlockData blockData) {
        this.setBlock(x, y, z, ((CraftBlockData)blockData).getState());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    public Material getType(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z).method_26204());
    }

    public MaterialData getTypeAndData(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z));
    }

    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getTypeId(x, y, z));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, class_2680 type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < 0) {
            yMin = 0;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y = yMin; y < yMax; ++y) {
            class_2826 section = this.getChunkSection(y, true);
            int offsetBase = y & 0xF;
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    section.method_16675(x, offsetBase, z, type);
                }
            }
        }
    }

    public class_2680 getTypeId(int x, int y, int z) {
        if (x != (x & 0xF) || y < 0 || y >= this.maxHeight || z != (z & 0xF)) {
            return class_2246.field_10124.method_9564();
        }
        class_2826 section = this.getChunkSection(y, false);
        return section == null ? class_2246.field_10124.method_9564() : section.method_12254(x, y & 0xF, z);
    }

    public byte getData(int x, int y, int z) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x, y, z));
    }

    private void setBlock(int x, int y, int z, class_2680 type) {
        if (x != (x & 0xF) || y < 0 || y >= this.maxHeight || z != (z & 0xF)) {
            return;
        }
        class_2826 section = this.getChunkSection(y, true);
        section.method_16675(x, y & 0xF, z, type);
        if (type.method_31709()) {
            if (this.tiles == null) {
                this.tiles = new HashSet<class_2338>();
            }
            this.tiles.add(new class_2338(x, y, z));
        }
    }

    private class_2826 getChunkSection(int y, boolean create) {
        class_2826 section = this.sections[y >> 4];
        IMixinMinecraftServer mc = (IMixinMinecraftServer)ICommonMod.getIServer().getMinecraft();
        if (create && section == null) {
            this.sections[y >> 4] = section = mc.newChunkSection(y >> 4 << 4);
        }
        return section;
    }

    public class_2826[] getRawChunkData() {
        return this.sections;
    }

    public Set<class_2338> getTiles() {
        return this.tiles;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    @NotNull
    public Biome getBiome(int arg0, int arg1, int arg2) {
        return null;
    }

    public int getHeight(@NotNull HeightMap heightMap, @Range(from=0L, to=15L) int x, @Range(from=0L, to=15L) int z) {
        throw new UnsupportedOperationException("Unsupported, in older chunk generator api");
    }
}

