/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.library;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cardboardpowered.library.KnotHelper;
import org.cardboardpowered.library.Library;
import org.cardboardpowered.mixin.CardboardMixinPlugin;

public final class LibraryManager {
    private static final Logger logger = LogManager.getLogger((String)"Cardboard");
    private final String defaultRepository;
    private final File directory;
    private final boolean validateChecksum;
    private final int maxDownloadAttempts;
    private final Collection<Library> libraries;
    private static final String PAPER_MAVEN = "https://repo.papermc.io/repository/maven-snapshots";
    private static final String[] BACKUP = new String[]{"https://web.archive.org/web/20250923053753/https://repo.papermc.io/repository/maven-snapshots/io/papermc/paper/paper-api/1.21.8-R0.1-SNAPSHOT/paper-api-1.21.8-R0.1-20250906.215025-55.jar"};

    public LibraryManager(String defaultRepository, String directoryName, boolean validateChecksum, int maxDownloadAttempts, Collection<Library> libraries) {
        Preconditions.checkNotNull((Object)defaultRepository);
        Preconditions.checkNotNull((Object)directoryName);
        this.defaultRepository = defaultRepository;
        this.directory = new File(directoryName);
        this.validateChecksum = validateChecksum;
        this.maxDownloadAttempts = maxDownloadAttempts;
        this.libraries = libraries;
    }

    public void run() {
        if (!this.directory.isDirectory() && !this.directory.mkdirs()) {
            logger.error("Could not create libraries directory: " + String.valueOf(this.directory));
        }
        for (Library lib : this.libraries) {
            String fn = lib.libraryKey.artifactId + "-" + lib.version + ".jar";
            File f = new File(this.directory, fn);
            if (f.isFile() && !fn.contains("intermediary-adapter")) {
                try {
                    KnotHelper.propose(f);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.download(lib);
        }
        String adv = KnotHelper.ver_adventure + " (" + KnotHelper.loaded_adventure + ")";
        String det = "Paper-API: " + KnotHelper.ver_paper + "; Adventure: " + adv + "; BungeeChat: " + KnotHelper.ver_bungeechat;
        KnotHelper.LOGGER.info("Loaded " + KnotHelper.loaded + " libraries. " + det);
    }

    private static String read_central_checksum(String repository, Library library) throws IOException {
        String inputLine;
        if (library.libraryKey.artifactId.contains("paper-api")) {
            return "paper";
        }
        URL url = null;
        try {
            url = new URL(repository + library.libraryKey.groupId.replace('.', '/') + "/" + library.libraryKey.artifactId + "/" + library.version + "/" + library.libraryKey.artifactId + "-" + library.version + ".jar.sha1");
        }
        catch (MalformedURLException e) {
            try {
                url = new URL("https://web.archive.org/web/20250518125104/https://repo.papermc.io/repository/maven-snapshots/io/papermc/paper/paper-api/1.21.4-R0.1-SNAPSHOT/paper-api-1.21.4-R0.1-20250511.205801-225.jar.sha1");
            }
            catch (MalformedURLException e2) {
                logger.error("Failed to create URL for checksum: " + e2.getMessage());
                return null;
            }
        }
        URLConnection urlc = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream(), "UTF-8"));
        StringBuilder a = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            a.append(inputLine);
        }
        in.close();
        return a.toString();
    }

    public static void main(String[] args) throws Exception {
        List<Library> list = CardboardMixinPlugin.getLibs();
        for (Library l : list) {
            String s = "Unknown";
            try {
                s = LibraryManager.read_central_checksum("https://repo1.maven.org/maven2/", l);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (s.equalsIgnoreCase("paper")) {
                String ver = l.version.split("-R0.1")[0];
                String paper_jar = "https://repo.papermc.io/repository/maven-snapshots/io/papermc/paper/paper-api/" + ver + "-R0.1-SNAPSHOT/paper-api-" + l.version + ".jar";
                URL downloadUrl = new URL(paper_jar);
                File file = new File("papertest.jar");
                HttpsURLConnection connection = (HttpsURLConnection)downloadUrl.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 Chrome/90.0.4430.212");
                try (ReadableByteChannel input = Channels.newChannel(connection.getInputStream());
                     FileOutputStream output = new FileOutputStream(file);){
                    output.getChannel().transferFrom(input, 0L, Long.MAX_VALUE);
                    logger.info("Downloaded " + l.toString() + ".");
                }
                catch (FileNotFoundException ex) {
                    logger.info("Note: repo.papermc.io is misbehaving. Attempting backup URL..");
                }
                if (l.checksumType != null && l.checksumValue != null && !LibraryManager.checksum(file, l)) {
                    logger.error("The checksum of does not match. Found: " + l.checksumValue2 + ", Need: " + l.checksumValue);
                }
            }
            if (s.equalsIgnoreCase(l.checksumValue)) continue;
            logger.info(String.valueOf(l) + " : " + s);
        }
    }

    public void download(Library library) {
        String fileName;
        File file;
        Object repository = library.repository;
        if (repository == null) {
            repository = this.defaultRepository;
        }
        if (!((String)repository).endsWith("/")) {
            repository = (String)repository + "/";
        }
        if (!(file = new File(this.directory, fileName = library.libraryKey.artifactId + "-" + library.version + ".jar")).exists()) {
            int attempts = 0;
            while (attempts < this.maxDownloadAttempts) {
                ++attempts;
                logger.info("Downloading " + library.toString() + "...");
                try {
                    URL downloadUrl;
                    if (library.libraryKey.artifactId.contains("adapter")) {
                        downloadUrl = new URL("https://github.com/CardboardPowered/worldedit-adapters/releases/download/1.17.1/we-adapter-for-cardboard.jar");
                    } else if (null == library.libraryKey.spigotJarVersion) {
                        downloadUrl = new URL((String)repository + library.libraryKey.groupId.replace('.', '/') + "/" + library.libraryKey.artifactId + "/" + library.version + "/" + library.libraryKey.artifactId + "-" + library.version + ".jar");
                    } else {
                        String ver = library.version.split("-R0.1")[0];
                        String paper_jar = "https://repo.papermc.io/repository/maven-snapshots/io/papermc/paper/paper-api/" + ver + "-R0.1-SNAPSHOT/paper-api-" + library.version + ".jar";
                        downloadUrl = new URL(paper_jar);
                    }
                    HttpsURLConnection connection = (HttpsURLConnection)downloadUrl.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 Chrome/90.0.4430.212");
                    try (ReadableByteChannel input = Channels.newChannel(connection.getInputStream());
                         FileOutputStream output = new FileOutputStream(file);){
                        output.getChannel().transferFrom(input, 0L, Long.MAX_VALUE);
                        logger.info("Downloaded " + library.toString() + ".");
                    }
                    catch (FileNotFoundException ex) {
                        logger.info("Note: repo.papermc.io is misbehaving. Attempting backup URL..");
                        for (String urll : BACKUP) {
                            downloadUrl = new URL(urll);
                            connection = (HttpsURLConnection)downloadUrl.openConnection();
                            try (ReadableByteChannel input2 = Channels.newChannel(connection.getInputStream());
                                 FileOutputStream output2 = new FileOutputStream(file);){
                                output2.getChannel().transferFrom(input2, 0L, Long.MAX_VALUE);
                                logger.info("Downloaded " + library.toString() + ".");
                            }
                            catch (FileNotFoundException ex2) {
                                ex2.printStackTrace();
                            }
                        }
                    }
                    if (!this.validateChecksum || library.checksumType == null || library.checksumValue == null || LibraryManager.checksum(file, library)) break;
                    String rc = LibraryManager.read_central_checksum((String)repository, library);
                    System.out.println("RC:" + rc);
                    if (rc.equals(library.checksumValue2)) {
                        logger.info("The checksum of '" + fileName + "' (" + rc + ") has matched.");
                        break;
                    }
                    logger.error("The checksum of '" + fileName + "' does not match. Found: " + library.checksumValue2 + ", Need: " + library.checksumValue);
                    file.delete();
                    if (attempts != this.maxDownloadAttempts) continue;
                    return;
                }
                catch (IOException e) {
                    logger.warn("Failed to download: " + library.toString(), (Throwable)e);
                    file.delete();
                    if (attempts == this.maxDownloadAttempts) {
                        logger.warn("Restart the server to attempt downloading '" + fileName + "' again.");
                        return;
                    }
                    logger.warn("Attempting download of '" + fileName + "' again (" + (attempts + 1) + "/" + this.maxDownloadAttempts + ")");
                }
            }
        } else if (this.validateChecksum && library.checksumType != null && library.checksumValue != null && !LibraryManager.checksum(file, library)) {
            logger.warn("The checksum for the library '" + fileName + "' does not match. Remove the library and restart the server to download it again.");
        }
        try {
            if (!library.libraryKey.artifactId.contains("adapter")) {
                KnotHelper.propose(file);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to add to classpath: " + library.toString(), (Throwable)e);
        }
    }

    static boolean checksum(File file, Library library) {
        String digest;
        Preconditions.checkNotNull((Object)file);
        if (!file.exists()) {
            return false;
        }
        HashAlgorithm algorithm = library.checksumType;
        String checksum = library.checksumValue;
        if (algorithm == null || checksum == null || checksum.isEmpty()) {
            return true;
        }
        try {
            library.checksumValue2 = digest = Files.hash((File)file, (HashFunction)algorithm.function).toString();
            if (checksum.equalsIgnoreCase("giveme")) {
                logger.info("Hash for " + file.getName() + " = " + digest);
            }
        }
        catch (IOException ex) {
            logger.error("Failed to compute digest for '" + file.getName() + "'", (Throwable)ex);
            return false;
        }
        return digest.equals(checksum);
    }

    public static enum HashAlgorithm {
        SHA1(Hashing.sha1()),
        MD5(Hashing.md5());

        public final HashFunction function;

        private HashAlgorithm(HashFunction function) {
            this.function = function;
        }
    }
}

