/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_3176;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.profile.PlayerTextures;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.interfaces.IUserCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class CraftPlayerProfile
implements PlayerProfile {
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();
    static final String PROPERTY_NAME = "textures";

    public CraftPlayerProfile(CraftPlayer player) {
        this.profile = player.getHandle().method_7334();
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = new GameProfile(id, name);
    }

    public CraftPlayerProfile(GameProfile profile) {
        Validate.notNull((Object)profile, (String)"GameProfile cannot be null!", (Object[])new Object[0]);
        this.profile = profile;
    }

    public boolean hasProperty(String property) {
        return this.profile.getProperties().containsKey((Object)property);
    }

    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.getProperties();
        properties.removeAll((Object)name);
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }

    public UUID getId() {
        return this.profile.getId();
    }

    public UUID setId(UUID uuid) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(uuid, prev.getName());
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getId();
    }

    public String getName() {
        return this.profile.getName();
    }

    public String setName(String name) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(prev.getId(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getName();
    }

    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    public void clearProperties() {
        this.profile.getProperties().clear();
    }

    public boolean removeProperty(String property) {
        return !this.profile.getProperties().removeAll((Object)property).isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return this.profile.toString();
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    public boolean isComplete() {
        return this.getUniqueId() != null && this.getName() != null && !this.getTextures().isEmpty();
    }

    public boolean completeFromCache() {
        class_3176 server = CraftServer.INSTANCE.getServer();
        return this.completeFromCache(false, server.method_3828() || SpigotConfig.bungee);
    }

    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        GameProfile profile;
        Optional<GameProfile> o;
        GameProfile profile2;
        class_3176 server = CraftServer.INSTANCE.getServer();
        String name = this.profile.getName();
        IUserCache userCache = CraftServer.getUC();
        if (this.profile.getId() == null && (profile2 = onlineMode ? (lookupUUID ? userCache.card_findByName(name).get() : userCache.card_findByName(name).get()) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) != null) {
            CraftPlayerProfile.copyProfileProperties(this.profile, profile2);
            this.profile = profile2;
        }
        if ((this.profile.getName() == null || !this.hasTextures()) && this.profile.getId() != null && (o = userCache.card_getByUuid(this.profile.getId())).isPresent() && (profile = o.get()) != null) {
            CraftPlayerProfile.copyProfileProperties(this.profile, profile);
            this.profile = profile;
        }
        return this.isProfileComplete();
    }

    public boolean complete(boolean textures) {
        class_3176 server = CraftServer.INSTANCE.getServer();
        return this.complete(textures, server.method_3828() || SpigotConfig.bungee);
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        class_3176 server = CraftServer.INSTANCE.getServer();
        boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
        if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
            GameProfile result = null;
            if (result != null) {
                CraftPlayerProfile.copyProfileProperties(result, this.profile, true);
            }
            if (this.isProfileComplete()) {
                CraftServer.server.method_3793().method_14508(this.profile);
                CraftServer.server.method_3793().method_14518();
            }
        }
        return this.isProfileComplete() && (!onlineMode || !textures || this.hasTextures());
    }

    private boolean isProfileComplete() {
        return this.profile.getId() != null && StringUtils.isNotBlank(this.profile.getName());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        PropertyMap sourceProperties = source.getProperties();
        PropertyMap targetProperties = target.getProperties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.name());
            targetProperties.put((Object)property.name(), (Object)property);
        }
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.name(), property.value(), property.signature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        CraftPlayerProfile profile = new CraftPlayerProfile(gameProfile.getId(), gameProfile.getName());
        CraftPlayerProfile.copyProfileProperties(gameProfile, profile.profile);
        return profile;
    }

    public static PlayerProfile asBukkitMirror(GameProfile profile) {
        return new CraftPlayerProfile(profile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return CraftPlayerProfile.asAuthlib(craft.clone());
    }

    public static GameProfile asAuthlib(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    @Nullable
    public UUID getUniqueId() {
        return this.getId();
    }

    @NotNull
    public CompletableFuture<PlayerProfile> update() {
        return CompletableFuture.supplyAsync(() -> {
            CraftPlayerProfile clone = this.clone();
            clone.complete(true);
            return clone;
        }, (Executor)class_156.method_18349());
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.getId() != null) {
            map.put("uniqueId", this.getId().toString());
        }
        if (this.getName() != null) {
            map.put("name", this.getName());
        }
        if (!this.properties.isEmpty()) {
            ArrayList propertiesData = new ArrayList();
            for (ProfileProperty profileProperty : this.properties) {
            }
            map.put("properties", propertiesData);
        }
        return map;
    }

    @NotNull
    public PlayerTextures getTextures() {
        return null;
    }

    public void setTextures(@Nullable PlayerTextures arg0) {
    }

    public GameProfile buildGameProfile() {
        GameProfile profile = new GameProfile(this.profile.getId(), this.profile.getName());
        profile.getProperties().putAll((Multimap)this.profile.getProperties());
        return profile;
    }

    public static GameProfile validateSkullProfile(GameProfile gameProfile) {
        boolean isValidSkullProfile = gameProfile.getName() != null || gameProfile.getProperties().containsKey((Object)PROPERTY_NAME);
        return gameProfile;
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(this, CraftPlayerProfile.this.profile.getProperties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.getProperties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c) {
            CraftPlayerProfile.this.setProperties(c);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof ProfileProperty && CraftPlayerProfile.this.profile.getProperties().containsKey((Object)((ProfileProperty)o).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(PropertySet propertySet, Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

