/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.class_10191;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.checkerframework.checker.nullness.qual.Nullable;

public record PaperEquippable(class_10192 impl) implements Equippable,
Handleable<class_10192>
{
    @Override
    public class_10192 getHandle() {
        return this.impl;
    }

    public EquipmentSlot slot() {
        return CraftEquipmentSlot.getSlot(this.impl.comp_3174());
    }

    public Key equipSound() {
        return PaperAdventure.asAdventure(((class_3414)this.impl.comp_3175().comp_349()).comp_3319());
    }

    public @Nullable Key assetId() {
        return this.impl.comp_3176().map(PaperAdventure::asAdventureKey).orElse(null);
    }

    public @Nullable Key cameraOverlay() {
        return this.impl.comp_3306().map(PaperAdventure::asAdventure).orElse(null);
    }

    public @Nullable RegistryKeySet<EntityType> allowedEntities() {
        return this.impl.comp_3177().map(set -> PaperRegistrySets.convertToApi(RegistryKey.ENTITY_TYPE, set)).orElse(null);
    }

    public boolean dispensable() {
        return this.impl.comp_3178();
    }

    public boolean swappable() {
        return this.impl.comp_3213();
    }

    public boolean damageOnHurt() {
        return this.impl.comp_3214();
    }

    public boolean equipOnInteract() {
        return this.impl.comp_3523();
    }

    public boolean canBeSheared() {
        return this.impl.comp_4362();
    }

    public Key shearSound() {
        return PaperAdventure.asAdventure(((class_3414)this.impl.comp_4363().comp_349()).comp_3319());
    }

    public Equippable.Builder toBuilder() {
        return ((BuilderImpl)((BuilderImpl)((BuilderImpl)new BuilderImpl(this.slot()).equipSound(this.equipSound()).assetId(this.assetId()).cameraOverlay(this.cameraOverlay()).allowedEntities(this.allowedEntities()).dispensable(this.dispensable()).swappable(this.swappable()).damageOnHurt(this.damageOnHurt())).equipOnInteract(this.equipOnInteract())).shearSound(this.shearSound())).canBeSheared(this.canBeSheared());
    }

    static final class BuilderImpl
    implements Equippable.Builder {
        private final class_1304 equipmentSlot;
        private class_6880<class_3414> equipSound = class_3417.field_14883;
        private Optional<class_5321<class_10394>> assetId = Optional.empty();
        private Optional<class_2960> cameraOverlay = Optional.empty();
        private Optional<class_6885<class_1299<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;
        private boolean equipOnInteract;
        private boolean canBeSheared = false;
        private class_6880<class_3414> shearSound = class_7923.field_41172.method_47983((Object)class_3417.field_59992);

        BuilderImpl(EquipmentSlot equipmentSlot) {
            this.equipmentSlot = CraftEquipmentSlot.getNMS(equipmentSlot);
        }

        public Equippable.Builder equipSound(Key sound) {
            this.equipSound = PaperAdventure.resolveSound(sound);
            return this;
        }

        public Equippable.Builder assetId(@Nullable Key assetId) {
            this.assetId = Optional.ofNullable(assetId).map(key -> PaperAdventure.asVanilla(class_10191.field_55214, key));
            return this;
        }

        public Equippable.Builder cameraOverlay(@Nullable Key cameraOverlay) {
            this.cameraOverlay = Optional.ofNullable(cameraOverlay).map(PaperAdventure::asVanilla);
            return this;
        }

        public Equippable.Builder allowedEntities(@Nullable RegistryKeySet<EntityType> allowedEntities) {
            this.allowedEntities = Optional.ofNullable(allowedEntities).map(set -> PaperRegistrySets.convertToNms(class_7924.field_41266, Conversions.global().lookup(), set));
            return this;
        }

        public Equippable.Builder dispensable(boolean dispensable) {
            this.dispensable = dispensable;
            return this;
        }

        public Equippable.Builder swappable(boolean swappable) {
            this.swappable = swappable;
            return this;
        }

        public Equippable.Builder damageOnHurt(boolean damageOnHurt) {
            this.damageOnHurt = damageOnHurt;
            return this;
        }

        public Equippable.Builder equipOnInteract(boolean equipOnInteract) {
            this.equipOnInteract = equipOnInteract;
            return this;
        }

        public Equippable.Builder canBeSheared(boolean canBeSheared) {
            this.canBeSheared = canBeSheared;
            return this;
        }

        public Equippable.Builder shearSound(Key shearSound) {
            this.shearSound = PaperAdventure.resolveSound(shearSound);
            return this;
        }

        public Equippable build() {
            return new PaperEquippable(new class_10192(this.equipmentSlot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract, this.canBeSheared, this.shearSound));
        }
    }
}

