/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3544;
import net.minecraft.class_9296;
import org.bukkit.craftbukkit.util.Handleable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperResolvableProfile(class_9296 impl) implements ResolvableProfile,
Handleable<class_9296>
{
    static PaperResolvableProfile toApi(PlayerProfile profile) {
        return new PaperResolvableProfile(new class_9296(CraftPlayerProfile.asAuthlibCopy(profile)));
    }

    @Override
    public class_9296 getHandle() {
        return this.impl;
    }

    public @Nullable UUID uuid() {
        return this.impl.comp_2411().orElse(null);
    }

    public @Nullable String name() {
        return this.impl.comp_2410().orElse(null);
    }

    public @Unmodifiable Collection<ProfileProperty> properties() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2412().values(), input -> new ProfileProperty(input.name(), input.value(), input.signature()));
    }

    public CompletableFuture<PlayerProfile> resolve() {
        return this.impl.method_57507().thenApply(resolvableProfile -> CraftPlayerProfile.asBukkitCopy(resolvableProfile.comp_2413()));
    }

    static final class BuilderImpl
    implements ResolvableProfile.Builder {
        private final PropertyMap propertyMap = new PropertyMap();
        private @Nullable String name;
        private @Nullable UUID uuid;

        BuilderImpl() {
        }

        public ResolvableProfile.Builder name(@Nullable String name) {
            if (name != null) {
                Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (String)"name cannot be more than 16 characters, was %s", (int)name.length());
                Preconditions.checkArgument((boolean)class_3544.method_57179((String)name), (String)"name cannot include invalid characters, was %s", (Object)name);
            }
            this.name = name;
            return this;
        }

        public ResolvableProfile.Builder uuid(@Nullable UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public ResolvableProfile.Builder addProperty(ProfileProperty property) {
            Property newProperty = new Property(property.getName(), property.getValue(), property.getSignature());
            if (!this.propertyMap.containsEntry((Object)property.getName(), (Object)newProperty)) {
                int newSize = this.propertyMap.size() + 1;
                Preconditions.checkArgument((newSize <= 16 ? 1 : 0) != 0, (String)"Cannot have more than 16 properties, was %s", (int)newSize);
            }
            this.propertyMap.put((Object)property.getName(), (Object)newProperty);
            return this;
        }

        public ResolvableProfile.Builder addProperties(Collection<ProfileProperty> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        public ResolvableProfile build() {
            PropertyMap shallowCopy = new PropertyMap();
            shallowCopy.putAll((Multimap)this.propertyMap);
            return new PaperResolvableProfile(new class_9296(Optional.ofNullable(this.name), Optional.ofNullable(this.uuid), shallowCopy));
        }
    }
}

