/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryAccessHolder;
import io.papermc.paper.registry.RegistryHolder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.legacy.DelayedRegistry;
import io.papermc.paper.registry.legacy.DelayedRegistryEntry;
import io.papermc.paper.registry.legacy.LegacyRegistryIdentifiers;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jetbrains.annotations.VisibleForTesting;

@DefaultQualifier(value=NonNull.class)
public class PaperRegistryAccess
implements RegistryAccess {
    private final Map<RegistryKey<?>, RegistryHolder<?>> registries = new ConcurrentHashMap();

    public static PaperRegistryAccess instance() {
        return (PaperRegistryAccess)RegistryAccessHolder.INSTANCE.orElseThrow(() -> new IllegalStateException("No RegistryAccess implementation found"));
    }

    @VisibleForTesting
    public Set<RegistryKey<?>> getLoadedServerBackedRegistries() {
        return this.registries.keySet().stream().filter(registryHolder -> {
            RegistryEntry entry = PaperRegistries.getEntry(registryHolder);
            return entry != null && !(entry.meta() instanceof RegistryEntryMeta.ApiOnly);
        }).collect(Collectors.toUnmodifiableSet());
    }

    @Deprecated(forRemoval=true)
    public <T extends Keyed> Registry<T> getRegistry(Class<T> type) {
        RegistryKey<T> registryKey = PaperRegistryAccess.byType(type);
        if (registryKey == null) {
            return null;
        }
        RegistryEntry entry = PaperRegistries.getEntry(registryKey);
        RegistryHolder<?> registry = this.registries.get(registryKey);
        if (registry != null) {
            return registry.get();
        }
        if (entry instanceof DelayedRegistryEntry) {
            RegistryHolder.Delayed delayedHolder = new RegistryHolder.Delayed();
            this.registries.put(registryKey, delayedHolder);
            return delayedHolder.get();
        }
        return null;
    }

    public <T extends Keyed> Registry<T> getRegistry(RegistryKey<T> key) {
        if (PaperRegistries.getEntry(key) == null) {
            throw new NoSuchElementException(String.valueOf(key) + " is not a valid registry key");
        }
        RegistryHolder<?> registryHolder = this.registries.get(key);
        if (registryHolder == null) {
            throw new IllegalArgumentException(String.valueOf(key) + " points to a registry that is not available yet");
        }
        return PaperRegistryAccess.possiblyUnwrap(registryHolder.get());
    }

    private static <T extends Keyed> Registry<T> possiblyUnwrap(Registry<T> registry) {
        if (registry instanceof DelayedRegistry) {
            DelayedRegistry delayedRegistry = (DelayedRegistry)registry;
            return delayedRegistry.delegate();
        }
        return registry;
    }

    public <M> void registerReloadableRegistry(class_5321<? extends class_2378<M>> resourceKey, class_2378<M> registry) {
        this.registerRegistry(resourceKey, registry, true);
    }

    public <M> void registerRegistry(class_5321<? extends class_2378<M>> resourceKey, class_2378<M> registry) {
        this.registerRegistry(resourceKey, registry, false);
    }

    private <M, B extends Keyed, R extends Registry<B>> void registerRegistry(class_5321<? extends class_2378<M>> resourceKey, class_2378<M> registry, boolean replace) {
        @Nullable RegistryEntry<M, T> entry = PaperRegistries.getEntry(resourceKey);
        if (entry == null) {
            return;
        }
        @Nullable RegistryHolder<?> registryHolder = this.registries.get(entry.apiKey());
        if (registryHolder == null || replace) {
            this.registries.put(entry.apiKey(), entry.createRegistryHolder(registry));
        } else if (registryHolder instanceof RegistryHolder.Delayed && entry instanceof DelayedRegistryEntry) {
            DelayedRegistryEntry delayedEntry = (DelayedRegistryEntry)entry;
            ((RegistryHolder.Delayed)registryHolder).loadFrom(delayedEntry, registry);
        } else {
            throw new IllegalArgumentException(String.valueOf(resourceKey) + " has already been created");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static <T extends Keyed> RegistryKey<T> byType(Class<T> type) {
        return LegacyRegistryIdentifiers.CLASS_TO_KEY_MAP.get(type);
    }

    public <M> void lockReferenceHolders(class_5321<? extends class_2378<M>> resourceKey) {
        RegistryEntryMeta.ServerSide serverSide;
        RegistryEntryMeta registryEntryMeta;
        RegistryEntry entry = PaperRegistries.getEntry(resourceKey);
        if (entry == null || !((registryEntryMeta = entry.meta()) instanceof RegistryEntryMeta.ServerSide) || !(serverSide = (RegistryEntryMeta.ServerSide)registryEntryMeta).registryTypeMapper().constructorUsesHolder()) {
            return;
        }
        CraftRegistry registry = (CraftRegistry)this.getRegistry(entry.apiKey());
        registry.lockReferenceHolders();
    }
}

