/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.util;

import com.google.common.base.Preconditions;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperRegistryBuilderFactory;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.class_10726;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.CraftRegistry;
import org.cardboardpowered.adventure.WrapperAwareSerializer;
import org.cardboardpowered.interfaces.IRegistryInfoGetter;
import org.cardboardpowered.interfaces.IRegistryWrapperImpl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jetbrains.annotations.Contract;

@DefaultQualifier(value=NonNull.class)
public class Conversions {
    private static @Nullable Conversions globalInstance;
    private final class_6903.class_7863 lookup;
    private final WrapperAwareSerializer serializer;

    public static Conversions global() {
        if (globalInstance == null) {
            final class_5455 globalAccess = CraftRegistry.getMinecraftRegistry();
            globalInstance = new Conversions(new class_6903.class_7863(){

                public <T> Optional<class_6903.class_7862<T>> method_46623(class_5321<? extends class_2378<? extends T>> registryRef) {
                    class_2378 registry = globalAccess.method_30530(registryRef);
                    return Optional.of(new class_6903.class_7862((class_7876)registry, (class_7871)registry, registry.method_46766()));
                }
            });
        }
        return globalInstance;
    }

    public Conversions(class_6903.class_7863 lookup) {
        this.lookup = lookup;
        this.serializer = new WrapperAwareSerializer(() -> class_6903.method_40414((DynamicOps)JavaOps.INSTANCE, (class_6903.class_7863)lookup));
    }

    public class_6903.class_7863 lookup() {
        return this.lookup;
    }

    @Contract(value="null -> null; !null -> !null")
    public @Nullable class_2561 asVanilla(@Nullable Component adventure) {
        if (adventure == null) {
            return null;
        }
        return this.serializer.serialize(adventure);
    }

    public Component asAdventure(@Nullable class_2561 vanilla) {
        return vanilla == null ? Component.empty() : this.serializer.deserialize(vanilla);
    }

    public ClientTextureAsset asBukkit(@Nullable class_10726 clientTextureAsset) {
        return clientTextureAsset == null ? null : ClientTextureAsset.clientTextureAsset((Key)PaperAdventure.asAdventure(clientTextureAsset.comp_3626()), (Key)PaperAdventure.asAdventure(clientTextureAsset.comp_3627()));
    }

    public class_10726 asVanilla(@Nullable ClientTextureAsset clientTextureAsset) {
        return clientTextureAsset == null ? null : new class_10726(PaperAdventure.asVanilla(clientTextureAsset.identifier()), PaperAdventure.asVanilla(clientTextureAsset.texturePath()));
    }

    private static <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> RegistryEntryMeta.Buildable<M, A, B> getDirectHolderBuildableMeta(RegistryKey<A> registryKey) {
        RegistryEntryMeta.Buildable buildableMeta = PaperRegistries.getBuildableMeta(registryKey);
        Preconditions.checkArgument((boolean)buildableMeta.registryTypeMapper().supportsDirectHolders(), (Object)"Registry type mapper must support direct holders");
        return buildableMeta;
    }

    public <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> A createApiInstanceFromBuilder(RegistryKey<A> registryKey, Consumer<? super PaperRegistryBuilderFactory<M, A, B>> value) {
        RegistryEntryMeta.Buildable<M, A, B> meta = Conversions.getDirectHolderBuildableMeta(registryKey);
        PaperRegistryBuilderFactory<M, A, B> builderFactory = this.createRegistryBuilderFactory(registryKey, meta);
        value.accept(builderFactory);
        return (A)((Keyed)meta.registryTypeMapper().createBukkit(class_6880.method_40223(builderFactory.requireBuilder().build())));
    }

    private <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> PaperRegistryBuilderFactory<M, A, B> createRegistryBuilderFactory(RegistryKey<A> registryKey, RegistryEntryMeta.Buildable<M, A, B> buildableMeta) {
        class_5321 resourceRegistryKey = PaperRegistries.registryToNms(registryKey);
        class_7225.class_7226 lookupForBuilders = ((IRegistryInfoGetter)this.lookup).lookupForValueCopyViaBuilders().method_46762(resourceRegistryKey);
        return new PaperRegistryBuilderFactory(resourceRegistryKey, this, buildableMeta.builderFiller(), ((IRegistryWrapperImpl)lookupForBuilders)::getValueForCopying);
    }
}

