/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.JavaTypeSort;

final class ArrayType
implements JavaType {
    private final JavaType elementType;
    private int hashCode = 0;

    public ArrayType(JavaType elementType) {
        this.elementType = Objects.requireNonNull(elementType);
    }

    @Override
    public JavaType getElementType() {
        return this.elementType;
    }

    @Override
    public JavaTypeSort getSort() {
        return JavaTypeSort.ARRAY_TYPE;
    }

    @Override
    public String getInternalName() {
        return this.elementType.getInternalName() + "[]";
    }

    @Override
    public String getDescriptor() {
        return "[" + this.elementType.getDescriptor();
    }

    @Override
    public String getName() {
        return this.elementType.getName() + "[]";
    }

    @Override
    public JavaType mapClass(UnaryOperator<JavaType> func) {
        int dimensions = 1;
        JavaType elementType = this.getElementType();
        while (elementType.isArrayType()) {
            elementType = elementType.getElementType();
            ++dimensions;
        }
        return JavaType.createArray(dimensions, elementType.mapClass(func));
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            JavaType innermostType = this.elementType;
            int dimensions = 1;
            while (innermostType instanceof ArrayType) {
                innermostType = ((ArrayType)innermostType).elementType;
                ++dimensions;
            }
            hashCode = dimensions + ~innermostType.hashCode();
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ArrayType.class && obj.hashCode() == this.hashCode() && this.getElementType().equals(((ArrayType)obj).getElementType());
    }

    public String toString() {
        return this.getName();
    }
}

