/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.key.Key;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2304;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftContainer;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.cardboardpowered.impl.block.CardboardSign;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.entity.LivingEntityImpl;
import org.cardboardpowered.impl.inventory.CardboardDoubleChestInventory;
import org.cardboardpowered.impl.inventory.CardboardInventoryView;
import org.cardboardpowered.impl.inventory.CardboardPlayerInventory;
import org.cardboardpowered.impl.inventory.recipe.RecipeInterface;
import org.cardboardpowered.interfaces.IMixinEntity;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.cardboardpowered.interfaces.IMixinServerEntityPlayer;
import org.cardboardpowered.util.PermissionHook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CraftHumanEntity
extends LivingEntityImpl
implements HumanEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private CardboardPlayerInventory inventory;
    protected GameMode gm;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;

    public void openSign(Sign sign, Side side) {
        CardboardSign.openSign(sign, (CraftPlayer)this, side);
    }

    public CraftHumanEntity(class_1657 entity) {
        super((class_1297)entity);
        this.nms = entity;
        this.gm = CraftServer.INSTANCE.getDefaultGameMode();
        this.inventory = new CardboardPlayerInventory(entity.field_7514);
    }

    public class_1657 getHandle() {
        return (class_1657)this.nms;
    }

    public IMixinServerEntityPlayer getInterface() {
        return (class_3222)this.nms;
    }

    public void closeInventory() {
        this.getInterface().method_7346();
    }

    public boolean discoverRecipe(NamespacedKey arg0) {
        return this.discoverRecipes(Arrays.asList(arg0)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().method_7254(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    private Collection<class_8786<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        class_1863 manager = this.getHandle().method_37908().method_8503().method_3772();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional recipe = manager.method_8130(RecipeInterface.toMinecraft(recipeKey));
            recipe.ifPresent(recipes::add);
        }
        return recipes;
    }

    public float getAttackCooldown() {
        return this.getHandle().method_7261(0.5f);
    }

    public Location getBedLocation() {
        class_2338 bed = (class_2338)this.getHandle().method_18398().get();
        return new Location(this.getWorld(), (double)bed.method_10263(), (double)bed.method_10264(), (double)bed.method_10260());
    }

    public int getCooldown(Material arg0) {
        return 0;
    }

    public Inventory getEnderChest() {
        return null;
    }

    public int getExpToLevel() {
        return this.getHandle().method_7349();
    }

    public GameMode getGameMode() {
        return this.gm;
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public ItemStack getItemOnCursor() {
        return null;
    }

    public MainHand getMainHand() {
        return this.nms.method_6068() == class_1306.field_6182 ? MainHand.LEFT : MainHand.RIGHT;
    }

    public InventoryView getOpenInventory() {
        return ((IMixinScreenHandler)this.getHandle().field_7512).getBukkitView();
    }

    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().method_7356().method_33133()) {
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.getHandle().method_71370(), LOGGER);){
                Entity entity;
                Entity entity2 = entity = (Entity)class_1299.method_5892((class_11368)class_11352.method_71417((class_8942)scopedCollector.method_54946(() -> ".shoulder"), (class_7225.class_7874)this.getHandle().method_56673(), (class_2487)this.getHandle().method_7356()), (class_1937)this.getHandle().method_37908(), (class_3730)class_3730.field_52444).map(IMixinEntity::getBukkitEntity).orElse(null);
                return entity2;
            }
        }
        return null;
    }

    public Entity getShoulderEntityRight() {
        if (!this.getHandle().method_7308().method_33133()) {
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.getHandle().method_71370(), LOGGER);){
                Entity entity;
                Entity entity2 = entity = (Entity)class_1299.method_5892((class_11368)class_11352.method_71417((class_8942)scopedCollector.method_54946(() -> ".shoulder"), (class_7225.class_7874)this.getHandle().method_56673(), (class_2487)this.getHandle().method_7308()), (class_1937)this.getHandle().method_37908(), (class_3730)class_3730.field_52444).map(IMixinEntity::getBukkitEntity).orElse(null);
                return entity2;
            }
        }
        return null;
    }

    public int getSleepTicks() {
        return this.getHandle().field_7487;
    }

    public boolean hasCooldown(Material arg0) {
        return this.hasCooldown(new ItemStack(arg0));
    }

    public boolean hasCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getHandle().method_7357().method_7904(CraftItemStack.asNMSCopy(item));
    }

    public boolean isBlocking() {
        return this.getHandle().method_6039();
    }

    @Override
    public boolean isHandRaised() {
        return this.getHandle().method_6115();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        class_2338 pos = new class_2338(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.getHandle().method_17355(((class_2331)class_2246.field_10485).method_17454(null, this.getHandle().method_37908(), pos));
        if (force) {
            ((IMixinScreenHandler)this.getHandle().field_7512).setCheckReachable(false);
        }
        return ((IMixinScreenHandler)this.getHandle().field_7512).getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        class_2586 te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof class_3222)) {
            return null;
        }
        class_3222 player = (class_3222)this.getHandle();
        class_1703 formerContainer = this.getHandle().field_7512;
        class_3908 iinventory = null;
        if (inventory instanceof CardboardDoubleChestInventory) {
            iinventory = ((CardboardDoubleChestInventory)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof class_3908) {
            iinventory = (class_3908)craft.getInventory();
        }
        if (iinventory instanceof class_3908 && iinventory instanceof class_2586 && !(te = (class_2586)iinventory).method_11002()) {
            te.method_31662(this.getHandle().method_37908());
            te.field_11867 = this.getHandle().method_24515();
        }
        class_3917 container = CraftContainer.getNotchInventoryType(inventory);
        if (iinventory instanceof class_2624) {
            this.getHandle().method_17355(iinventory);
        } else {
            this.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().field_7512 == formerContainer) {
            return null;
        }
        ((IMixinScreenHandler)this.getHandle().field_7512).setCheckReachable(false);
        return ((IMixinScreenHandler)this.getHandle().field_7512).getBukkitView();
    }

    public void openCustomInventory(Inventory inventory, class_3222 player, class_3917<?> windowType) {
        if (player.field_13987 == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        CraftContainer container = new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = ((IMixinScreenHandler)((Object)container)).getBukkitView().getTitle();
        player.field_13987.method_14364((class_2596)new class_3944(container.field_7763, windowType, CraftChatMessage.fromString(title)[0]));
        this.getHandle().field_7512 = container;
        if (CraftServer.INSTANCE.getMinecraftVersion().contains("1.16")) {
            container.method_7596((class_1712)((class_3222)this));
        } else {
            ((class_3222)this.getHandle()).method_14235((class_1703)container);
        }
    }

    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof class_3222)) {
            return;
        }
        if (((class_3222)this.getHandle()).field_13987 == null) {
            return;
        }
        if (this.getHandle().field_7512 != this.getHandle().field_7498) {
            ((class_3222)this.getHandle()).field_13987.method_12054(new class_2815(this.getHandle().field_7512.field_7763));
        }
        class_3222 player = (class_3222)this.getHandle();
        Object container = inventory instanceof CardboardInventoryView ? ((CardboardInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        class_3917 windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        String title = inventory.getTitle();
        player.field_13987.method_14364((class_2596)new class_3944(container.field_7763, windowType, CraftChatMessage.fromString(title)[0]));
        player.field_7512 = container;
        if (CraftServer.INSTANCE.getMinecraftVersion().contains("1.16")) {
            container.method_7596((class_1712)((class_3222)this));
        } else {
            ((class_3222)this.getHandle()).method_14235(container);
        }
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant arg0, boolean arg1) {
        return null;
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().method_17355(((class_2304)class_2246.field_9980).method_17454(null, this.getHandle().method_37908(), new class_2338(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        if (force) {
            ((IMixinScreenHandler)this.getHandle().field_7512).setCheckReachable(false);
        }
        return ((IMixinScreenHandler)this.getHandle().field_7512).getBukkitView();
    }

    public void setCooldown(Material arg0, int arg1) {
    }

    public void setGameMode(GameMode arg0) {
        this.gm = arg0;
    }

    public void setItemInHand(ItemStack arg0) {
        this.getInventory().setItemInHand(arg0);
    }

    public void setItemOnCursor(ItemStack item) {
        class_1799 stack = CraftItemStack.asNMSCopy(item);
    }

    public void setShoulderEntityLeft(Entity entity) {
        if (entity != null) {
            entity.remove();
        }
    }

    public void setShoulderEntityRight(Entity entity) {
        if (entity != null) {
            entity.remove();
        }
    }

    public boolean setWindowProperty(InventoryView.Property arg0, int arg1) {
        return false;
    }

    public boolean sleep(Location location, boolean force) {
        class_2338 blockposition = new class_2338(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        class_2680 iblockdata = this.getHandle().method_37908().method_8320(blockposition);
        if (!(iblockdata.method_26204() instanceof class_2244)) {
            return false;
        }
        if (this.getHandle().method_7269(blockposition).left().isPresent()) {
            return false;
        }
        iblockdata = (class_2680)iblockdata.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true));
        this.getHandle().method_37908().method_8652(blockposition, iblockdata, 4);
        return true;
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().method_7333(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public void wakeup(boolean arg0) {
        this.getHandle().method_7358(true, arg0);
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        boolean b = this.perm.hasPermission(name);
        if (!b && FabricLoader.getInstance().isModLoaded("cyber-permissions") && this.nms instanceof class_3222) {
            return PermissionHook.hasPermission((class_3222)this.nms, name);
        }
        return b;
    }

    @Override
    public boolean hasPermission(Permission perm) {
        boolean b = this.perm.hasPermission(perm);
        if (!b && FabricLoader.getInstance().isModLoaded("cyber-permissions") && this.nms instanceof class_3222) {
            return PermissionHook.hasPermission((class_3222)this.nms, perm.getName());
        }
        return b;
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    public boolean hasDiscoveredRecipe(NamespacedKey arg0) {
        return false;
    }

    public boolean dropItem(boolean dropAll) {
        return ((class_3222)this.getHandle()).method_37413(dropAll);
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    public void closeInventory(InventoryCloseEvent.Reason arg0) {
    }

    public Location getPotentialBedLocation() {
        return null;
    }

    public InventoryView openAnvil(Location arg0, boolean arg1) {
        return null;
    }

    public InventoryView openCartographyTable(Location arg0, boolean arg1) {
        return null;
    }

    public InventoryView openGrindstone(Location arg0, boolean arg1) {
        return null;
    }

    public InventoryView openLoom(Location arg0, boolean arg1) {
        return null;
    }

    public void openSign(Sign arg0) {
    }

    public InventoryView openSmithingTable(Location arg0, boolean arg1) {
        return null;
    }

    public InventoryView openStonecutter(Location arg0, boolean arg1) {
        return null;
    }

    public Entity releaseLeftShoulderEntity() {
        return null;
    }

    public Entity releaseRightShoulderEntity() {
        return null;
    }

    @Override
    @NotNull
    public EquipmentSlot getHandRaised() {
        return null;
    }

    @Override
    public boolean hasLineOfSight(@NotNull Location arg0) {
        return false;
    }

    @Override
    public void registerAttribute(@NotNull Attribute arg0) {
    }

    public float getExhaustion() {
        return 0.0f;
    }

    public int getFoodLevel() {
        return 0;
    }

    public int getSaturatedRegenRate() {
        return 0;
    }

    public float getSaturation() {
        return 0.0f;
    }

    public int getStarvationRate() {
        return 0;
    }

    public int getUnsaturatedRegenRate() {
        return 0;
    }

    public boolean isDeeplySleeping() {
        return false;
    }

    public void setExhaustion(float arg0) {
    }

    public void setFoodLevel(int arg0) {
    }

    public void setSaturatedRegenRate(int arg0) {
    }

    public void setSaturation(float arg0) {
        this.getHandle().method_7344().method_7581(arg0);
    }

    public void setStarvationRate(int arg0) {
    }

    public void setUnsaturatedRegenRate(int arg0) {
    }

    @Override
    @Nullable
    public ItemStack getItemInUse() {
        return CraftItemStack.asBukkitCopy(this.nms.method_6030());
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        class_1671 fireworks = new class_1671(this.getHandle().method_37908(), CraftItemStack.asNMSCopy(fireworkItemStack), (class_1309)this.getHandle());
        boolean success = this.getHandle().method_37908().method_8649((class_1297)fireworks);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    public FishHook getFishHook() {
        if (this.getHandle().field_7513 == null) {
            return null;
        }
        return (FishHook)this.getHandle().field_7513.getBukkitEntity();
    }

    @Nullable
    public Location getLastDeathLocation() {
        return this.getHandle().method_43122().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().method_43120(Optional.empty());
        }
    }

    public int getEnchantmentSeed() {
        return this.getHandle().method_7278();
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().field_7494 = i2;
    }

    public void startRiptideAttack(int duration, float damage, @Nullable ItemStack attackItem) {
        this.getHandle().method_40126(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public void setCooldown(ItemStack item, int ticks) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().method_7357().method_62835(CraftItemStack.asNMSCopy(item), ticks);
    }

    public int getCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        class_2960 group = this.getHandle().method_7357().method_62836(CraftItemStack.asNMSCopy(item));
        if (group == null) {
            return 0;
        }
        class_1796.class_1797 cooldown = (class_1796.class_1797)this.getHandle().method_7357().field_8024.get(group);
        return cooldown == null ? 0 : Math.max(0, cooldown.comp_3084() - this.getHandle().method_7357().field_8025);
    }

    public Item dropItem(int slot, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        Preconditions.checkArgument((slot >= 0 && slot < this.inventory.getSize() ? 1 : 0) != 0, (String)"Slot %s is not a valid inventory slot.", (int)slot);
        return this.internalDropItemFromInventory(this.inventory.getItem(slot), amount, throwRandomly, entityOperation);
    }

    @Nullable
    public Item dropItem(@NotNull EquipmentSlot slot, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        return this.internalDropItemFromInventory(this.inventory.getItem(slot), amount, throwRandomly, entityOperation);
    }

    @Nullable
    private Item internalDropItemFromInventory(ItemStack originalItemStack, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        if (originalItemStack == null || originalItemStack.isEmpty() || amount <= 0) {
            return null;
        }
        class_1799 nmsItemStack = CraftItemStack.unwrap(originalItemStack);
        class_1799 dropContent = nmsItemStack.method_7971(amount);
        class_1542 droppedEntity = this.getHandle().method_7329(dropContent, throwRandomly, true);
        return droppedEntity == null ? null : (Item)droppedEntity.getBukkitEntity();
    }

    public Item dropItem(ItemStack itemStack, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Cannot drop a null itemstack");
        if (itemStack.isEmpty()) {
            return null;
        }
        class_1799 nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        class_1542 droppedEntity = this.getHandle().method_7329(nmsItemStack, throwRandomly, true);
        return droppedEntity == null ? null : (Item)droppedEntity.getBukkitEntity();
    }

    public Location getPotentialRespawnLocation() {
        class_3222.class_10766 respawnConfig = ((class_3222)this.getHandle()).method_67564();
        if (respawnConfig == null) {
            return null;
        }
        class_3218 level = ((class_3222)this.getHandle()).method_5682().method_3847(respawnConfig.comp_3683());
        if (level == null) {
            return null;
        }
        return CraftLocation.toBukkit(respawnConfig.comp_3684(), (World)level.getWorld());
    }

    public int getCooldown(Key key) {
        class_1796.class_1797 cooldown = (class_1796.class_1797)this.getHandle().method_7357().field_8024.get(PaperAdventure.asVanilla(key));
        return cooldown == null ? 0 : Math.max(0, cooldown.comp_3084() - this.getHandle().method_7357().field_8025);
    }

    public void setCooldown(Key key, int ticks) {
        this.getHandle().method_7357().method_7906(PaperAdventure.asVanilla(key), ticks);
    }
}

