/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1715;
import net.minecraft.class_1725;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2589;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2615;
import net.minecraft.class_2627;
import net.minecraft.class_3719;
import net.minecraft.class_3720;
import net.minecraft.class_3722;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.InventoryIterator;
import org.bukkit.craftbukkit.util.CraftLegacy;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.cardboardpowered.impl.inventory.CardboardAnvilInventory;
import org.cardboardpowered.impl.inventory.CardboardBeaconInventory;
import org.cardboardpowered.impl.inventory.CardboardEnchantingInventory;
import org.cardboardpowered.impl.inventory.CardboardGrindstoneInventory;
import org.cardboardpowered.impl.inventory.CardboardLoomInventory;
import org.cardboardpowered.impl.inventory.CardboardStonecutterInventory;
import org.cardboardpowered.interfaces.IMixinInventory;

public class CraftInventory
implements Inventory {
    protected final class_1263 inventory;

    public CraftInventory(class_1263 inventory) {
        this.inventory = inventory;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public int getSize() {
        return this.getInventory().method_5439();
    }

    public ItemStack getItem(int index) {
        class_1799 item = this.getInventory().method_5438(index);
        return item.method_7960() ? null : CraftItemStack.asCraftMirror(item);
    }

    protected ItemStack[] asCraftMirror(List<class_1799> mcItems) {
        int size = mcItems.size();
        ItemStack[] items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            class_1799 mcItem = mcItems.get(i);
            items[i] = mcItem.method_7960() ? null : CraftItemStack.asCraftMirror(mcItem);
        }
        return items;
    }

    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    public ItemStack[] getContents() {
        return this.asCraftMirror(((IMixinInventory)this.getInventory()).getContents());
    }

    public void setContents(ItemStack[] items) {
        if (this.getSize() < items.length) {
            throw new IllegalArgumentException("Invalid inventory size: expected " + this.getSize() + " or less");
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.setItem(i, i >= items.length ? null : items[i]);
        }
    }

    public void setItem(int index, ItemStack item) {
        this.getInventory().method_5447(index, CraftItemStack.asNMSCopy(item));
    }

    public boolean contains(Material material) {
        material = CraftLegacy.fromLegacy(material);
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals((Object)i)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Material material, int amount) {
        material = CraftLegacy.fromLegacy(material);
        if (amount <= 0) {
            return true;
        }
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals((Object)i) || --amount > 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.isSimilar(i) || (amount -= i.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        material = CraftLegacy.fromLegacy(material);
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            slots.put(i, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getStorageContents();
            for (int i = 0; i < inventory.length; ++i) {
                if (!item.equals((Object)inventory[i])) continue;
                slots.put(i, inventory[i]);
            }
        }
        return slots;
    }

    public int first(Material material) {
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            return i;
        }
        return -1;
    }

    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !(withAmount ? item.equals((Object)inventory[i]) : item.isSimilar(inventory[i]))) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty() {
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int firstPartial(Material material) {
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material || item.getAmount() >= item.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getStorageContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack cItem = inventory[i];
            if (cItem == null || cItem.getAmount() >= cItem.getMaxStackSize() || !cItem.isSimilar((ItemStack)filteredItem)) continue;
            return i;
        }
        return -1;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block0;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    this.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                this.setItem(firstPartial, partialItem);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().method_5444();
    }

    public void remove(Material material) {
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            this.clear(i);
        }
    }

    public void remove(ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].equals((Object)item)) continue;
            this.clear(i);
        }
    }

    public void clear(int index) {
        this.setItem(index, null);
    }

    public void clear() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clear(i);
        }
    }

    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    public List<HumanEntity> getViewers() {
        return ((IMixinInventory)this.inventory).getViewers();
    }

    public InventoryType getType() {
        if (this.inventory instanceof class_1715) {
            return this.inventory.method_5439() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof class_1661) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof class_2608) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof class_2601) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof class_3720) {
            return InventoryType.BLAST_FURNACE;
        }
        if (this.inventory instanceof class_3723) {
            return InventoryType.SMOKER;
        }
        if (this.inventory instanceof class_3866) {
            return InventoryType.FURNACE;
        }
        if (this instanceof CardboardEnchantingInventory) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof class_2589) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof class_1730) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof class_1725) {
            return InventoryType.MERCHANT;
        }
        if (this instanceof CardboardBeaconInventory) {
            return InventoryType.BEACON;
        }
        if (this instanceof CardboardAnvilInventory) {
            return InventoryType.ANVIL;
        }
        if (this.inventory instanceof class_2615) {
            return InventoryType.HOPPER;
        }
        if (this.inventory instanceof class_2627) {
            return InventoryType.SHULKER_BOX;
        }
        if (this.inventory instanceof class_3719) {
            return InventoryType.BARREL;
        }
        if (this.inventory instanceof class_3722) {
            return InventoryType.LECTERN;
        }
        if (this instanceof CardboardLoomInventory) {
            return InventoryType.LOOM;
        }
        if (this instanceof CardboardGrindstoneInventory) {
            return InventoryType.GRINDSTONE;
        }
        if (this instanceof CardboardStonecutterInventory) {
            return InventoryType.STONECUTTER;
        }
        return InventoryType.CHEST;
    }

    public InventoryHolder getHolder() {
        return ((IMixinInventory)this.inventory).getOwner();
    }

    public int getMaxStackSize() {
        return ((IMixinInventory)this.inventory).getMaxStackSize();
    }

    public void setMaxStackSize(int size) {
        ((IMixinInventory)this.inventory).setMaxStackSize(size);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftInventory && ((CraftInventory)obj).inventory.equals((Object)this.inventory);
    }

    public Location getLocation() {
        return ((IMixinInventory)this.inventory).getLocation();
    }

    public boolean isEmpty() {
        return false;
    }

    public InventoryHolder getHolder(boolean arg0) {
        return this.getHolder();
    }

    public HashMap<Integer, ItemStack> removeItemAnySlot(ItemStack ... arg0) throws IllegalArgumentException {
        return null;
    }

    public int close() {
        return 0;
    }
}

