/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.destroystokyo.paper.inventory.meta.ArmorStandMeta;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaArmorStand
extends CraftMetaItem
implements ArmorStandMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9279> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49609, "entity-tag");
    static final CraftMetaItem.ItemMetaKey INVISIBLE = new CraftMetaItem.ItemMetaKey("Invisible", "invisible");
    static final CraftMetaItem.ItemMetaKey NO_BASE_PLATE = new CraftMetaItem.ItemMetaKey("NoBasePlate", "no-base-plate");
    static final CraftMetaItem.ItemMetaKey SHOW_ARMS = new CraftMetaItem.ItemMetaKey("ShowArms", "show-arms");
    static final CraftMetaItem.ItemMetaKey SMALL = new CraftMetaItem.ItemMetaKey("Small", "small");
    static final CraftMetaItem.ItemMetaKey MARKER = new CraftMetaItem.ItemMetaKey("Marker", "marker");
    private Boolean invisible = null;
    private Boolean noBasePlate = null;
    private Boolean showArms = null;
    private Boolean small = null;
    private Boolean marker = null;
    class_2487 entityTag;

    CraftMetaArmorStand(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaArmorStand)) {
            return;
        }
        CraftMetaArmorStand armorStand = (CraftMetaArmorStand)meta;
        this.invisible = armorStand.invisible;
        this.noBasePlate = armorStand.noBasePlate;
        this.showArms = armorStand.showArms;
        this.small = armorStand.small;
        this.marker = armorStand.marker;
        this.entityTag = armorStand.entityTag;
    }

    CraftMetaArmorStand(class_9326 tag, Set<class_9331<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaArmorStand.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.method_57461();
            if (this.entityTag.method_10545(CraftMetaArmorStand.INVISIBLE.NBT)) {
                this.invisible = this.entityTag.method_10577(CraftMetaArmorStand.INVISIBLE.NBT).orElse(this.invisible);
            }
            if (this.entityTag.method_10545(CraftMetaArmorStand.NO_BASE_PLATE.NBT)) {
                this.noBasePlate = this.entityTag.method_10577(CraftMetaArmorStand.NO_BASE_PLATE.NBT).orElse(this.noBasePlate);
            }
            if (this.entityTag.method_10545(CraftMetaArmorStand.SHOW_ARMS.NBT)) {
                this.showArms = this.entityTag.method_10577(CraftMetaArmorStand.SHOW_ARMS.NBT).orElse(this.showArms);
            }
            if (this.entityTag.method_10545(CraftMetaArmorStand.SMALL.NBT)) {
                this.small = this.entityTag.method_10577(CraftMetaArmorStand.SMALL.NBT).orElse(this.small);
            }
            if (this.entityTag.method_10545(CraftMetaArmorStand.MARKER.NBT)) {
                this.marker = this.entityTag.method_10577(CraftMetaArmorStand.MARKER.NBT).orElse(this.marker);
            }
        });
    }

    CraftMetaArmorStand(Map<String, Object> map) {
        super(map);
        this.invisible = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaArmorStand.INVISIBLE.BUKKIT);
        this.noBasePlate = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaArmorStand.NO_BASE_PLATE.BUKKIT);
        this.showArms = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaArmorStand.SHOW_ARMS.BUKKIT);
        this.small = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaArmorStand.SMALL.BUKKIT);
        this.marker = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaArmorStand.MARKER.BUKKIT);
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        Optional opt;
        super.deserializeInternal(tag, context);
        if (tag.method_10545(CraftMetaArmorStand.ENTITY_TAG.NBT) && (opt = tag.method_10562(CraftMetaArmorStand.ENTITY_TAG.NBT)).isPresent()) {
            this.entityTag = (class_2487)opt.get();
        }
    }

    @Override
    void serializeInternal(Map<String, class_2520> internalTags) {
        if (this.entityTag != null && !this.entityTag.method_33133()) {
            internalTags.put(CraftMetaArmorStand.ENTITY_TAG.NBT, (class_2520)this.entityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (!this.isArmorStandEmpty() && this.entityTag == null) {
            this.entityTag = new class_2487();
        }
        if (this.invisible != null) {
            this.entityTag.method_10556(CraftMetaArmorStand.INVISIBLE.NBT, this.invisible.booleanValue());
        }
        if (this.noBasePlate != null) {
            this.entityTag.method_10556(CraftMetaArmorStand.NO_BASE_PLATE.NBT, this.noBasePlate.booleanValue());
        }
        if (this.showArms != null) {
            this.entityTag.method_10556(CraftMetaArmorStand.SHOW_ARMS.NBT, this.showArms.booleanValue());
        }
        if (this.small != null) {
            this.entityTag.method_10556(CraftMetaArmorStand.SMALL.NBT, this.small.booleanValue());
        }
        if (this.marker != null) {
            this.entityTag.method_10556(CraftMetaArmorStand.MARKER.NBT, this.marker.booleanValue());
        }
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, class_9279.method_57456((class_2487)this.entityTag));
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.ARMOR_STAND;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isArmorStandEmpty();
    }

    boolean isArmorStandEmpty() {
        return this.invisible == null && this.noBasePlate == null && this.showArms == null && this.small == null && this.marker == null && this.entityTag == null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaArmorStand) {
            CraftMetaArmorStand that = (CraftMetaArmorStand)meta;
            return this.invisible == that.invisible && this.noBasePlate == that.noBasePlate && this.showArms == that.showArms && this.small == that.small && this.marker == that.marker;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaArmorStand || this.isArmorStandEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        return original != (hash += this.isMarker() ? 61 * (hash += this.isSmall() ? 61 * (hash += this.shouldShowArms() ? 61 * (hash += this.hasNoBasePlate() ? 61 * (hash += this.isInvisible() ? 61 * (hash += this.entityTag != null ? 73 * hash + this.entityTag.hashCode() : 0) + 1231 : 0) + 1231 : 0) + 1231 : 0) + 1231 : 0) + 1231 : 0) ? CraftMetaArmorStand.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.invisible != null) {
            builder.put((Object)CraftMetaArmorStand.INVISIBLE.BUKKIT, (Object)this.invisible);
        }
        if (this.noBasePlate != null) {
            builder.put((Object)CraftMetaArmorStand.NO_BASE_PLATE.BUKKIT, (Object)this.noBasePlate);
        }
        if (this.showArms != null) {
            builder.put((Object)CraftMetaArmorStand.SHOW_ARMS.BUKKIT, (Object)this.showArms);
        }
        if (this.small != null) {
            builder.put((Object)CraftMetaArmorStand.SMALL.BUKKIT, (Object)this.small);
        }
        if (this.marker != null) {
            builder.put((Object)CraftMetaArmorStand.MARKER.BUKKIT, (Object)this.marker);
        }
        return builder;
    }

    @Override
    public CraftMetaArmorStand clone() {
        CraftMetaArmorStand clone = (CraftMetaArmorStand)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.method_10553();
        }
        return clone;
    }

    public boolean isInvisible() {
        return this.invisible != null && this.invisible != false;
    }

    public boolean hasNoBasePlate() {
        return this.noBasePlate != null && this.noBasePlate != false;
    }

    public boolean shouldShowArms() {
        return this.showArms != null && this.showArms != false;
    }

    public boolean isSmall() {
        return this.small != null && this.small != false;
    }

    public boolean isMarker() {
        return this.marker != null && this.marker != false;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.noBasePlate = noBasePlate;
    }

    public void setShowArms(boolean showArms) {
        this.showArms = showArms;
    }

    public void setSmall(boolean small) {
        this.small = small;
    }

    public void setMarker(boolean marker) {
        this.marker = marker;
    }
}

