/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9336;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.util.BlockVector;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.interfaces.IComponentChanges;
import org.cardboardpowered.interfaces.IMixinBlockEntity;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    private static final Set<Material> BLOCK_STATE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.FURNACE, Material.CHEST, Material.TRAPPED_CHEST, Material.JUKEBOX, Material.DISPENSER, Material.DROPPER, Material.ACACIA_HANGING_SIGN, Material.ACACIA_SIGN, Material.ACACIA_WALL_HANGING_SIGN, Material.ACACIA_WALL_SIGN, Material.BAMBOO_HANGING_SIGN, Material.BAMBOO_SIGN, Material.BAMBOO_WALL_HANGING_SIGN, Material.BAMBOO_WALL_SIGN, Material.BIRCH_HANGING_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_HANGING_SIGN, Material.BIRCH_WALL_SIGN, Material.CHERRY_HANGING_SIGN, Material.CHERRY_SIGN, Material.CHERRY_WALL_HANGING_SIGN, Material.CHERRY_WALL_SIGN, Material.CRIMSON_HANGING_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_HANGING_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_HANGING_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_HANGING_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_HANGING_SIGN, Material.JUNGLE_WALL_SIGN, Material.MANGROVE_HANGING_SIGN, Material.MANGROVE_SIGN, Material.MANGROVE_WALL_HANGING_SIGN, Material.MANGROVE_WALL_SIGN, Material.OAK_HANGING_SIGN, Material.OAK_SIGN, Material.OAK_WALL_HANGING_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_HANGING_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_HANGING_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_HANGING_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_HANGING_SIGN, Material.WARPED_WALL_SIGN, Material.SPAWNER, Material.BREWING_STAND, Material.ENCHANTING_TABLE, Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.BEACON, Material.DAYLIGHT_DETECTOR, Material.HOPPER, Material.COMPARATOR, Material.SHIELD, Material.STRUCTURE_BLOCK, Material.ENDER_CHEST, Material.BARREL, Material.BELL, Material.BLAST_FURNACE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.JIGSAW, Material.LECTERN, Material.SMOKER, Material.BEEHIVE, Material.BEE_NEST, Material.SCULK_CATALYST, Material.SCULK_SHRIEKER, Material.SCULK_SENSOR, Material.CHISELED_BOOKSHELF, Material.DECORATED_POT, Material.SUSPICIOUS_SAND});
    static final CraftMetaItem.ItemMetaKeyType<class_9279> BLOCK_ENTITY_TAG;
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG_CUSTOM_DATA;
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_COMPONENTS;
    final Material material;
    class_9279 blockEntityTag;
    private class_2487 internalTag;
    class_9323 components;

    private Material materialForBlockEntityType() {
        return this.material;
    }

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            this.components = class_9323.field_49584;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.components = te.components;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(class_9326 tag, Material material, Set<class_9331<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        this.components = this.components != null ? this.components : class_9323.field_49584;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : class_9279.field_49302;
        this.material = material;
        this.updateBlockState(tag);
    }

    private void updateBlockState(class_9326 tag) {
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(nbt -> {
            this.blockEntityTag = nbt;
        });
        if (!tag.method_57848()) {
            class_9323.class_9324 map = class_9323.method_57827();
            class_2586 dummyBlockEntity = Objects.requireNonNull(CraftBlockStates.createNewBlockEntity(this.materialForBlockEntityType()));
            Set<class_9331<?>> applied = ((IMixinBlockEntity)dummyBlockEntity).applyComponentsSet(class_9323.field_49584, class_9326.field_49588);
            for (class_9331<?> seen : applied) {
                ((IComponentChanges)this.unhandledTags).clear(seen);
            }
            if (!applied.isEmpty()) {
                for (class_9331<?> type : applied) {
                    if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(type)) continue;
                    CraftMetaBlockState.getOrEmpty(tag, type).ifPresent(value -> map.method_57840(type, value));
                }
            }
            this.components = map.method_57838();
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        BlockVector legacyPosition;
        this.components = this.components != null ? this.components : class_9323.field_49584;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : class_9279.field_49302;
        String blockMaterial = CraftMetaItem.SerializableMeta.getString(map, "blockMaterial", true);
        Material material = Material.getMaterial((String)blockMaterial);
        this.material = material != null ? material : Material.AIR;
        Material material2 = this.material;
        if (this.internalTag != null) {
            this.setBlockState(CraftMetaBlockState.getBlockState(this.material, this.internalTag));
            this.internalTag = null;
        }
        if ((legacyPosition = CraftMetaItem.SerializableMeta.getObject(BlockVector.class, map, "blockPosition", true)) != null) {
            this.blockEntityTag = this.blockEntityTag.method_57451(blockEntityTag -> {
                try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "blockEntityTag", CraftMetaItem.LOGGER);){
                    class_11362 output = CraftMetaBlockState.NbtWriteView_createWrappingWithContext(problemReporter, CraftRegistry.getMinecraftRegistry(), blockEntityTag);
                    if (blockEntityTag.method_33133()) {
                        class_2586.method_38238((class_11372)output, Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
                    }
                    output.method_71465("x", legacyPosition.getBlockX());
                    output.method_71465("y", legacyPosition.getBlockY());
                    output.method_71465("z", legacyPosition.getBlockZ());
                }
            });
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        class_2487 nbt = this.blockEntityTag.method_57461();
        if (!nbt.method_33133()) {
            if (nbt.method_10558("id").isEmpty()) {
                try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "CraftMetaBlockState#apply", CraftMetaItem.LOGGER);){
                    class_2586.method_38238((class_11372)CraftMetaBlockState.NbtWriteView_createWrappingWithContext(problemReporter, CraftRegistry.getMinecraftRegistry(), nbt), Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
                }
            }
            tag.put(BLOCK_ENTITY_TAG, class_9279.method_57456((class_2487)nbt));
        }
        for (class_9336 component : this.components) {
            if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(component.comp_2443())) continue;
            tag.builder.method_57855(component);
        }
    }

    public static class_11362 NbtWriteView_createWrappingWithContext(class_8942.class_11340 problemReporter, class_5455 lookup, class_2487 compoundTag) {
        return new class_11362((class_8942)problemReporter, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), compoundTag);
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        super.deserializeInternal(tag, context);
        Optional blockEntityTag = tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        if (blockEntityTag.isPresent()) {
            this.internalTag = (class_2487)blockEntityTag.get();
            return;
        }
        tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT).ifPresent(blockEntityCustomTag -> {
            this.blockEntityTag = class_9279.method_57456((class_2487)blockEntityCustomTag);
        });
        tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT).ifPresent(components -> {
            this.components = (class_9323)class_9323.field_50234.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), components).getOrThrow();
        });
    }

    @Override
    void serializeInternal(Map<String, class_2520> internalTags) {
        if (!this.blockEntityTag.method_57458()) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT, (class_2520)this.blockEntityTag.method_57463());
        }
        if (!this.components.method_57837()) {
            class_2520 componentsTag = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), (Object)this.components).getOrThrow();
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT, componentsTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equals(this.blockEntityTag, that.blockEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag == null;
    }

    @Override
    boolean applicableTo(Material type) {
        return BLOCK_STATE_MATERIALS.contains(type);
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        meta.blockEntityTag = this.blockEntityTag;
        meta.components = this.components;
        return meta;
    }

    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    public void clearBlockState() {
        this.blockEntityTag = null;
    }

    public CardboardBlockEntityState<?> getBlockState() {
        class_2338 pos = class_2338.field_10980;
        Material stateMaterial = this.materialForBlockEntityType();
        if (!this.blockEntityTag.method_57458()) {
            pos = class_2586.method_38239(null, (class_2487)this.blockEntityTag.method_57463());
        }
        class_2591<?> type = Objects.requireNonNull(CraftBlockStates.getBlockEntityType(stateMaterial));
        class_2680 nmsBlockState = ((CraftBlockData)this.getBlockData(stateMaterial)).getState();
        class_2586 blockEntity = Objects.requireNonNull(type.method_11032(pos, nmsBlockState));
        if (!this.blockEntityTag.method_57458()) {
            this.blockEntityTag.method_57449(blockEntity, (class_7225.class_7874)CraftRegistry.getMinecraftRegistry());
        }
        class_9335 patchedMap = new class_9335(nmsBlockState.method_26204().method_8389().method_57347());
        patchedMap.method_57933(this.components);
        CraftMetaItem.Applicator applicator = new CraftMetaItem.Applicator(this){};
        super.applyToItem(applicator);
        patchedMap.method_57936(applicator.build());
        blockEntity.method_58685(nmsBlockState.method_26204().method_8389().method_57347(), patchedMap.method_57940());
        return (CardboardBlockEntityState)CraftBlockStates.getBlockState(null, pos, nmsBlockState, blockEntity);
    }

    private static CardboardBlockEntityState<?> getBlockState(Material material, class_2487 blockEntityTag) {
        class_2338 pos = class_2338.field_10980;
        Material stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack(blockEntityTag);
        Material material2 = stateMaterial;
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.method_10582("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.method_10582("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.method_10582("id", "minecraft:shulker_box");
            }
            pos = class_2586.method_38239(null, (class_2487)blockEntityTag);
        }
        return (CardboardBlockEntityState)CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), pos, stateMaterial, blockEntityTag);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(null);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CardboardBlockEntityState ? 1 : 0) != 0, (String)"Invalid blockState for %s", (Object)this.material);
        CardboardBlockEntityState craftBlockState = (CardboardBlockEntityState)blockState;
        class_2487 data = craftBlockState.getSnapshotCustomNbtOnly();
        class_9335 patchedMap = new class_9335(craftBlockState.getHandle().method_26204().method_8389().method_57347());
        class_9323 map = craftBlockState.collectComponents();
        patchedMap.method_57933(map);
        if (!data.method_33133()) {
            patchedMap.method_57938(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, (Object)class_9279.method_57456((class_2487)data));
        }
        class_9326 patch = patchedMap.method_57940();
        this.updateFromPatch(patch, null);
        this.blockEntityTag = class_9279.field_49302;
        this.components = class_9323.field_49584;
        this.updateBlockState(patch);
    }

    @Deprecated
    private static Material shieldToBannerHack() {
        return Material.WHITE_BANNER;
    }

    private static Material shieldToBannerHack(class_2487 tag) {
        Optional baseColor;
        if (tag != null && (baseColor = tag.method_10562("components").flatMap(components -> components.method_10558("minecraft:base_color"))).isPresent()) {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)class_1767.method_7793((String)((String)baseColor.get()), (class_1767)class_1767.field_7952).method_7789()));
            return CraftMetaShield.shieldToBannerHack(color);
        }
        return Material.WHITE_BANNER;
    }

    static {
        BLOCK_ENTITY_TAG_CUSTOM_DATA = new CraftMetaItem.ItemMetaKey("block-entity-tag");
        BLOCK_ENTITY_COMPONENTS = new CraftMetaItem.ItemMetaKey("block-entity-components");
        BLOCK_STATE_MATERIALS.addAll(SHULKER_BOX_MATERIALS);
        BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49611, "BlockEntityTag");
    }

    private static final class TrackedDataComponentMap
    implements class_9323 {
        private final Set<class_9331<?>> seen = new HashSet();
        private final class_9323 handle;

        public TrackedDataComponentMap(class_9323 map) {
            this.handle = map;
        }

        public <T> T method_58694(class_9331<? extends T> type) {
            this.seen.add(type);
            return (T)this.handle.method_58694(type);
        }

        public Set<class_9331<?>> method_57831() {
            return this.handle.method_57831();
        }

        public Iterator<class_9336<?>> iterator() {
            return this.handle.iterator();
        }
    }
}

