/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataAdapterContext;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftNBTTagConfigSerializer;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class CraftPersistentDataContainer
implements PersistentDataContainer {
    private final Map<String, class_2520> customDataTags = new HashMap<String, class_2520>();
    private final CraftPersistentDataTypeRegistry registry;
    private final CraftPersistentDataAdapterContext adapterContext;

    public CraftPersistentDataContainer(Map<String, class_2520> customTags, CraftPersistentDataTypeRegistry registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CraftPersistentDataContainer(CraftPersistentDataTypeRegistry registry) {
        this.registry = registry;
        this.adapterContext = new CraftPersistentDataAdapterContext(this.registry);
    }

    public class_2520 getTag(String key) {
        return this.customDataTags.get(key);
    }

    public <T, Z> void set(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        this.customDataTags.put(key.toString(), this.registry.wrap(type, type.toPrimitive(value, (PersistentDataAdapterContext)this.adapterContext)));
    }

    public <P, C> boolean has(NamespacedKey key, PersistentDataType<P, C> type) {
        class_2520 value = this.getTag(key.toString());
        if (value == null) {
            return false;
        }
        return this.registry.isInstanceOf(type, value);
    }

    public <P, C> C get(NamespacedKey key, PersistentDataType<P, C> type) {
        class_2520 value = this.getTag(key.toString());
        if (value == null) {
            return null;
        }
        return (C)type.fromPrimitive(this.registry.extract(type, value), (PersistentDataAdapterContext)this.adapterContext);
    }

    public <T, Z> Z getOrDefault(NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        Z z = this.get(key, type);
        return z != null ? z : defaultValue;
    }

    public void remove(NamespacedKey key) {
        Validate.notNull(key, "The provided key for the custom value was null");
        this.customDataTags.remove(key.toString());
    }

    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftPersistentDataContainer)) {
            return false;
        }
        return Objects.equals(this.getRaw(), ((CraftPersistentDataContainer)obj).getRaw());
    }

    public class_2487 toTagCompound() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, class_2520> entry : this.customDataTags.entrySet()) {
            tag.method_10566(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public void put(String key, class_2520 base) {
        this.customDataTags.put(key, base);
    }

    public void putAll(Map<String, class_2520> map) {
        this.customDataTags.putAll(map);
    }

    public void putAll(class_2487 compound) {
        for (String key : compound.method_10541()) {
            this.customDataTags.put(key, compound.method_10580(key));
        }
    }

    public Map<String, class_2520> getRaw() {
        return this.customDataTags;
    }

    public CraftPersistentDataTypeRegistry getDataTagTypeRegistry() {
        return this.registry;
    }

    public int hashCode() {
        return 3 + this.customDataTags.hashCode();
    }

    public String serialize() {
        return CraftNBTTagConfigSerializer.serialize((class_2520)this.toTagCompound());
    }

    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.customDataTags.keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    public boolean has(@NotNull NamespacedKey arg0) {
        class_2520 value = this.customDataTags.get(arg0.toString());
        return value != null;
    }

    public void readFromBytes(byte @NotNull [] arg0, boolean arg1) throws IOException {
    }

    public byte @NotNull [] serializeToBytes() throws IOException {
        return null;
    }

    public void copyTo(@NotNull PersistentDataContainer other, boolean replace) {
        CraftPersistentDataContainer target = (CraftPersistentDataContainer)other;
        if (replace) {
            target.customDataTags.putAll(this.customDataTags);
        } else {
            this.customDataTags.forEach(target.customDataTags::putIfAbsent);
        }
    }
}

