/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_5625;
import org.jetbrains.annotations.NotNull;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final class_2522<class_2520> MOJANGSON_PARSER = class_2522.method_68662((DynamicOps)class_2509.field_11560);

    public static String serialize(class_2520 tag) {
        class_5625 snbtVisitor = new class_5625();
        return snbtVisitor.method_32283(tag);
    }

    public static class_2520 deserialize(Object object) {
        if (object instanceof String) {
            String snbtString = (String)object;
            try {
                return class_2522.method_67315((String)snbtString);
            }
            catch (CommandSyntaxException e2) {
                throw new RuntimeException("Failed to deserialise nbt", e2);
            }
        }
        return CraftNBTTagConfigSerializer.internalLegacyDeserialization(object);
    }

    private static class_2520 internalLegacyDeserialization(@NotNull Object object) {
        if (object instanceof Map) {
            class_2487 compound = new class_2487();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.method_10566((String)entry.getKey(), CraftNBTTagConfigSerializer.internalLegacyDeserialization(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new class_2499();
            }
            class_2499 tagList = new class_2499();
            for (Object tag : list) {
                tagList.add((Object)CraftNBTTagConfigSerializer.internalLegacyDeserialization(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return (class_2520)MOJANGSON_PARSER.method_67319(new StringReader(string));
                }
                catch (CommandSyntaxException e2) {
                    throw new RuntimeException("Could not deserialize found list ", e2);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return class_2497.method_23247((int)Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return class_2489.method_23241((double)Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            try {
                class_2520 tag = (class_2520)MOJANGSON_PARSER.method_67319(new StringReader(string));
                if (tag instanceof class_2497) {
                    return class_2519.method_23256((String)tag.toString());
                }
                if (tag instanceof class_2489) {
                    return class_2519.method_23256((String)String.valueOf(((class_2489)tag).method_10697()));
                }
                if (tag instanceof class_2519) {
                    return class_2519.method_23256((String)string);
                }
                return tag;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new RuntimeException("Could not deserialize found primitive ", commandSyntaxException);
            }
        }
        throw new RuntimeException("Could not deserialize Tag");
    }
}

