/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import net.minecraft.class_3330;
import org.apache.commons.lang.StringUtils;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IpBanList
implements BanList {
    private final class_3317 list;

    public IpBanList(class_3317 list) {
        this.list = list;
    }

    public BanEntry getBanEntry(String target) {
        class_3320 entry = (class_3320)this.list.method_14640((Object)target);
        return entry == null ? null : new IpBanEntry(target, entry, this.list);
    }

    public BanEntry addBan(String target, String reason, Date expires, String source) {
        class_3320 entry = new class_3320(target, new Date(), StringUtils.isBlank(source) ? null : source, expires, StringUtils.isBlank(reason) ? null : reason);
        this.list.method_14633((class_3330)entry);
        try {
            this.list.method_14629();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned ips, " + ex.getMessage());
        }
        return new IpBanEntry(target, entry, this.list);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.method_14636()) {
            builder.add((Object)new IpBanEntry(target, Objects.requireNonNull((class_3320)this.list.method_14640((Object)target)), this.list));
        }
        return builder.build();
    }

    public boolean isBanned(String target) {
        return this.list.method_14527((SocketAddress)InetSocketAddress.createUnresolved(target, 0));
    }

    public void pardon(String target) {
        this.list.method_14635((Object)target);
    }

    @Nullable
    public BanEntry getBanEntry(@NotNull Object target) {
        return null;
    }

    @Nullable
    public BanEntry addBan(@NotNull Object target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public BanEntry addBan(@NotNull Object target, @Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public BanEntry addBan(@NotNull Object target, @Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        return null;
    }

    public Set<BanEntry<InetAddress>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.method_14636()) {
            class_3320 ipBanEntry = (class_3320)this.list.method_14640((Object)target);
            if (ipBanEntry == null) continue;
            builder.add((Object)new IpBanEntry(target, ipBanEntry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(@NotNull Object target) {
        return false;
    }

    public void pardon(@NotNull Object target) {
    }

    public static class IpBanEntry
    implements BanEntry {
        private final class_3317 list;
        private final String target;
        private Date created;
        private String source;
        private Date expiration;
        private String reason;

        public IpBanEntry(String target, class_3320 entry, class_3317 list) {
            this.list = list;
            this.target = target;
            this.created = null;
            this.source = entry.method_14501();
            this.expiration = entry.method_14502() != null ? new Date(entry.method_14502().getTime()) : null;
            this.reason = entry.method_14503();
        }

        public String getTarget() {
            return this.target;
        }

        public Date getCreated() {
            return this.created == null ? null : (Date)this.created.clone();
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Date getExpiration() {
            return this.expiration == null ? null : (Date)this.expiration.clone();
        }

        public void setExpiration(Date expiration) {
            if (expiration != null && expiration.getTime() == new Date(0, 0, 0, 0, 0, 0).getTime()) {
                expiration = null;
            }
            this.expiration = expiration;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void save() {
            class_3320 entry = new class_3320(this.target, this.created, this.source, this.expiration, this.reason);
            this.list.method_14633((class_3330)entry);
            try {
                this.list.method_14629();
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned ips json, " + ex.getMessage());
            }
        }

        public InetAddress getBanTarget() {
            return InetAddresses.forString((String)this.target);
        }

        public void remove() {
            this.list.method_14635((Object)this.target);
        }
    }
}

