/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.cardboardpowered.impl.entity.LivingEntityImpl;
import org.jetbrains.annotations.NotNull;

public class CardboardEntityEquipment
implements EntityEquipment {
    private final LivingEntityImpl entity;

    public CardboardEntityEquipment(LivingEntityImpl entity) {
        this.entity = entity;
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        class_1304 nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        class_1304 nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(class_1304.field_6173);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(class_1304.field_6173, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(class_1304.field_6171);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(class_1304.field_6171, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(class_1304.field_6169);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(class_1304.field_6169, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(class_1304.field_6174);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(class_1304.field_6174, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(class_1304.field_6172);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(class_1304.field_6172, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(class_1304.field_6166);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(class_1304.field_6166, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(class_1304.field_6166), this.getEquipment(class_1304.field_6172), this.getEquipment(class_1304.field_6174), this.getEquipment(class_1304.field_6169)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(class_1304.field_6166, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(class_1304.field_6172, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(class_1304.field_6174, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(class_1304.field_6169, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(class_1304 slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().method_6118(slot));
    }

    private void setEquipment(class_1304 slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().method_5673(slot, CraftItemStack.asNMSCopy(stack));
    }

    public void clear() {
        for (class_1304 slot : class_1304.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(class_1304.field_6173);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(class_1304.field_6173, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(class_1304.field_6171);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(class_1304.field_6171, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(class_1304.field_6169);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(class_1304.field_6169, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(class_1304.field_6174);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(class_1304.field_6174, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(class_1304.field_6172);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(class_1304.field_6172, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(class_1304.field_6166);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(class_1304.field_6166, chance);
    }

    private void setDropChance(class_1304 slot, float chance) {
        ((class_1308)this.entity.getHandle()).method_5946(slot, chance);
    }

    private float getDropChance(class_1304 slot) {
        if (!(this.entity.getHandle() instanceof class_1308)) {
            return 1.0f;
        }
        return ((class_1308)this.entity.getHandle()).method_66286().method_66240(slot);
    }

    public float getDropChance(@NotNull EquipmentSlot arg0) {
        return 0.0f;
    }

    public void setDropChance(@NotNull EquipmentSlot arg0, float arg1) {
    }
}

