/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util.nms;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodSignature;
import org.bukkit.Material;
import org.bukkit.craftbukkit.util.Commodore;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.CardboardMod;
import org.objectweb.asm.MethodVisitor;

public class ReflectionMethodVisitor
extends MethodVisitor {
    public static ArrayList<String> SKIP = new ArrayList();
    private String pln;
    private MappingResolver mr;

    public ReflectionMethodVisitor(int api, MethodVisitor visitMethod, String pln) {
        super(api, visitMethod);
        this.pln = pln;
        this.mr = FabricLoader.getInstance().getMappingResolver();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (CardboardConfig.DEBUG_VERBOSE_CALLS && !owner.startsWith("java/")) {
            CardboardMod.LOGGER.info(owner + " / " + name);
        }
        if (owner.equalsIgnoreCase("org/bukkit/Material") && CraftMagicNumbers.MODDED_MATERIALS.containsKey(name)) {
            super.visitFieldInsn(opcode, owner, "STONE", desc);
            return;
        }
        if (owner.startsWith("net/minecraft") && name.length() <= 2) {
            MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
            if (owner.contains("class_31$a")) {
                owner = owner.replace("class_31$a", "class_31$class_7729");
                if (name.equalsIgnoreCase("b")) {
                    name = "field_40374";
                }
                if (name.equalsIgnoreCase("a")) {
                    name = "field_40373";
                }
                if (name.equalsIgnoreCase("c")) {
                    name = "field_40375";
                }
            }
            if (desc.contains("class_31$a")) {
                desc = desc.replace("class_31$a", "class_31$class_7729");
            }
            String owner_official = mr.unmapClassName("official", owner.replace('/', '.'));
            Object sigg = "";
            JavaType jt = JavaType.fromDescriptor(desc);
            if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
                String in = jt.getInternalName().replace('/', '.');
                String ll = mr.unmapClassName("official", in);
                sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), ll).replace('.', '/');
            } else {
                sigg = (String)sigg + jt.getDescriptor();
            }
            String mapped = mr.mapFieldName("official", owner_official, name, (String)sigg);
            if (!mapped.startsWith("field_")) {
                String res = mapped;
                try {
                    String inn;
                    Class<?> up = Class.forName(owner.replace('/', '.'));
                    String in = ReflectionMethodVisitor.find_in_inheritance_f(up, res, desc, (String)sigg);
                    if (in.startsWith("field_")) {
                        res = in;
                    }
                    if (null != up.getSuperclass()) {
                        // empty if block
                    }
                    if (!res.startsWith("field_")) {
                        // empty if block
                    }
                    if (!res.startsWith("field_") && (inn = ReflectionMethodVisitor.find_in_inheritance_f(up, res, desc, (String)sigg)).startsWith("field_")) {
                        res = in;
                    }
                }
                catch (ClassNotFoundException e) {
                    CardboardMod.LOGGER.finest("MISSING CLASS MAPPING FOR: " + owner);
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mapped.equalsIgnoreCase("field_41255")) {
                mapped = "field_41254";
            }
            if (mapped.equalsIgnoreCase("field_41199")) {
                mapped = "field_41197";
            }
            super.visitFieldInsn(opcode, owner, mapped, desc);
            return;
        }
        if (name.equalsIgnoreCase("field_41255")) {
            name = "field_41254";
        }
        if (name.equalsIgnoreCase("field_41199")) {
            name = "field_41197";
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public static Field Material_getField(String name) throws NoSuchFieldException, SecurityException {
        try {
            return Material.class.getField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return Material.class.getField("STONE");
        }
    }

    public static String do_map(String owner, String name, String desc) {
        MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
        String owner_official = mr.unmapClassName("official", owner.replace('/', '.'));
        MethodSignature sig = MethodSignature.fromDescriptor(desc);
        List<JavaType> jts = sig.getParameterTypes();
        Object sigg = "(";
        for (JavaType jt : jts) {
            if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
                String in = jt.getInternalName().replace('/', '.');
                String ll = mr.unmapClassName("official", in);
                sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), ll).replace('.', '/');
                continue;
            }
            sigg = (String)sigg + jt.getDescriptor();
        }
        sigg = (String)sigg + ")";
        JavaType jt = sig.getReturnType();
        if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
            String in = jt.getInternalName().replace('/', '.');
            String ll = mr.unmapClassName("official", in);
            sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), ll).replace('.', '/');
        } else {
            sigg = (String)sigg + jt.getDescriptor();
        }
        String mapped = mr.mapMethodName("official", owner_official, name, (String)sigg);
        if (!mapped.startsWith("method_")) {
            String res = mapped;
            try {
                String inn;
                Class<?> up = Class.forName(owner.replace('/', '.'));
                String in = ReflectionMethodVisitor.find_in_inheritance(up, res, desc, (String)sigg);
                if (in.startsWith("method_")) {
                    return in;
                }
                if (null != up.getSuperclass()) {
                    String supn = up.getSuperclass().getName();
                    res = ReflectionMethodVisitor.do_map(supn, name, desc);
                }
                if (!res.startsWith("method_")) {
                    // empty if block
                }
                if (!res.startsWith("method_") && (inn = ReflectionMethodVisitor.find_in_inheritance(up, res, desc, (String)sigg)).startsWith("method_")) {
                    return in;
                }
            }
            catch (ClassNotFoundException e) {
                CardboardMod.LOGGER.finest("MISSING CLASS MAPPING FOR: " + owner);
                System.out.println("ClassNotFound: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mapped = res;
        }
        return mapped;
    }

    public static String find_in_inheritance(Class<?> clazz, String obf_name, String desc, String sigg) {
        String owner_official;
        MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
        String mapped = mr.mapMethodName("official", owner_official = mr.unmapClassName("official", clazz.getName().replace('/', '.')), obf_name, desc);
        if (mapped.startsWith("method_")) {
            return mapped;
        }
        String mapped2 = mr.mapMethodName("official", owner_official, obf_name, sigg);
        if (mapped2.startsWith("method_")) {
            return mapped2;
        }
        for (Class<?> ih : clazz.getInterfaces()) {
            String in = ReflectionMethodVisitor.find_in_inheritance(ih, obf_name, desc, sigg);
            if (!in.startsWith("method_")) continue;
            return in;
        }
        return obf_name;
    }

    public static String find_in_inheritance_f(Class<?> clazz, String obf_name, String desc, String sigg) {
        String owner_official;
        MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
        String mapped = mr.mapFieldName("official", owner_official = mr.unmapClassName("official", clazz.getName().replace('/', '.')), obf_name, desc);
        if (mapped.startsWith("field_")) {
            return mapped;
        }
        String mapped2 = mr.mapFieldName("official", owner_official, obf_name, sigg);
        if (mapped2.startsWith("field_")) {
            return mapped2;
        }
        for (Class<?> ih : clazz.getInterfaces()) {
            String in = ReflectionMethodVisitor.find_in_inheritance(ih, obf_name, desc, sigg);
            if (!in.startsWith("field_")) continue;
            return in;
        }
        return obf_name;
    }

    private void debug(String o) {
        if (CardboardConfig.DEBUG_VERBOSE_CALLS) {
            CardboardMod.LOGGER.info(o);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String namespace;
        if (CardboardConfig.DEBUG_VERBOSE_CALLS && !owner.startsWith("java/")) {
            CardboardMod.LOGGER.info(owner + " / " + name);
        }
        if (owner.contains("LegacyPotionMetaProvider")) {
            this.debug(owner + " " + name + " " + desc);
            owner = owner.replace("LegacyPotionMetaProvider", "ModernPotionMetaProvider");
        }
        if (owner.startsWith("org/bukkit/craftbukkit") && owner.contains("v1_21_R5")) {
            System.out.println("Stripping version package (v1_21_R5) from org/bukkit/craftbukkit reference.");
            owner = owner.replace("org/bukkit/craftbukkit/v1_21_R5/", "org/bukkit/craftbukkit/");
        }
        if (owner.startsWith("net/minecraft") && name.equals("getMinecraftServer")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ReflectionRemapper", "getNmsServer", desc, false);
            return;
        }
        if (owner.startsWith("net/minecraft") && name.equals("getServer")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ReflectionRemapper", "getNmsServer", desc, false);
            return;
        }
        if (name.contains("method_45136") && opcode == 184) {
            name = "method_12829";
        }
        if (owner.startsWith("net/minecraft") && name.length() <= 2) {
            MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
            String owner_official = mr.unmapClassName("official", owner.replace('/', '.'));
            MethodSignature sig = MethodSignature.fromDescriptor(desc);
            List<JavaType> jts = sig.getParameterTypes();
            Object sigg = "(";
            for (JavaType jt : jts) {
                if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
                    String in = jt.getInternalName().replace('/', '.');
                    String ll = mr.unmapClassName("official", in);
                    sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), ll).replace('.', '/');
                    continue;
                }
                sigg = (String)sigg + jt.getDescriptor();
            }
            sigg = (String)sigg + ")";
            JavaType jt = sig.getReturnType();
            if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
                String in = jt.getInternalName().replace('/', '.');
                String ll = mr.unmapClassName("official", in);
                sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), ll).replace('.', '/');
            } else {
                sigg = (String)sigg + jt.getDescriptor();
            }
            String mapped = mr.mapMethodName("official", owner_official, name, (String)sigg);
            if (!mapped.startsWith("method_") && name.equalsIgnoreCase(mapped)) {
                String res = mapped;
                try {
                    Class<?> up = Class.forName(owner.replace('/', '.'));
                    String in = ReflectionMethodVisitor.find_in_inheritance(up, res, desc, (String)sigg);
                    if (in.startsWith("method_")) {
                        res = in;
                    } else if (null != up.getSuperclass()) {
                        String supn = up.getSuperclass().getName();
                        res = ReflectionMethodVisitor.do_map(supn, name, desc);
                    }
                }
                catch (ClassNotFoundException e) {
                    CardboardMod.LOGGER.finest("MISSING CLASS MAPPING FOR: " + owner);
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!res.equalsIgnoreCase("I_") || desc.contains("Liu")) {
                    // empty if block
                }
                if (res.equalsIgnoreCase("f") && desc.contains("class_5321") && owner.contains("class_2378")) {
                    res = "method_40290";
                }
                if (!res.startsWith("method_")) {
                    // empty if block
                }
                mapped = res;
            }
            super.visitMethodInsn(opcode, owner, mapped, desc, itf);
            return;
        }
        if ((owner.contains("NbtCompound") || owner.contains("class_2487")) && name.startsWith("setString")) {
            String cl = this.mr.unmapClassName("intermediary", owner.replace('/', '.'));
            String name2 = this.mr.mapMethodName("intermediary", cl.replace('/', '.'), "method_10582", desc);
            super.visitMethodInsn(opcode, owner, name2, desc, false);
            return;
        }
        if (owner.equalsIgnoreCase("org/bukkit/Material") && name.equalsIgnoreCase("getField")) {
            System.out.println("\nGET MATERIAL FIELD!!!!!\n");
            super.visitFieldInsn(opcode, "org/cardboardpowered/util/nms/ReflectionMethodVisitor", "Material_getField", desc);
            return;
        }
        if (owner.equalsIgnoreCase("com/comphenix/protocol/utility/MinecraftReflection") && (name.equals("getCraftBukkitClass") || name.equals("getMinecraftClass"))) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ProtocolLibMapper", name, desc, false);
            return;
        }
        if (owner.equalsIgnoreCase("com/comphenix/protocol/injector/netty/ChannelInjector") && name.equals("guessCompression")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ProtocolLibMapper", name, desc, false);
            return;
        }
        if (owner.equalsIgnoreCase("com/sk89q/worldguard/bukkit/util/Materials") && (name.equals("isSpawnEgg") || name.equals("getEntitySpawnEgg") || name.equals("isArmor") || name.equals("isToolApplicable") || name.equals("isWaxedCopper"))) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/WorldGuardMaterialHelper", name, desc, false);
            return;
        }
        if (owner.startsWith("net/minecraft") && name.startsWith("method_") && (namespace = this.mr.getCurrentRuntimeNamespace()).equalsIgnoreCase("named")) {
            name = this.mr.mapMethodName("intermediary", owner.replace('/', '.'), name, desc);
        }
        for (String str : SKIP) {
            if (!this.pln.equalsIgnoreCase(str) && !owner.startsWith("org/bukkit")) continue;
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (owner.equalsIgnoreCase("java/lang/Class") && name.equalsIgnoreCase("forName") && desc.equalsIgnoreCase("(Ljava/lang/String;)Ljava/lang/Class;")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ReflectionRemapper", "mapClassName", "(Ljava/lang/String;)Ljava/lang/String;", false);
        }
        if (owner.equalsIgnoreCase("java/lang/Class") && name.equalsIgnoreCase("getMethods")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ReflectionRemapper", "getMethods", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", false);
            return;
        }
        if (owner.startsWith("net/minecraft/class_") && owner.equalsIgnoreCase("net/minecraft/class_3176") && name.equalsIgnoreCase("getVersion")) {
            super.visitMethodInsn(184, "org/cardboardpowered/util/nms/ReflectionRemapper", "getMinecraftServerVersion", "()Ljava/lang/String;", false);
            return;
        }
        owner = Commodore.getOriginalOrRewrite(owner);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    static {
        SKIP.add("vault");
        SKIP.add("worldguard");
    }
}

