/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util.nms;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.class_155;
import net.minecraft.class_3242;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.util.nms.MappingsReader;

public class ReflectionRemapper {
    public static final String NMS_VERSION = "v1_21_R5";
    public static JavaPlugin plugin;
    private static int BV_CALLED;

    public static String mapClassName(String className) {
        if (className.startsWith("net.ess3.provider.providers.LegacyPotionMetaProvider")) {
            return "net.ess3.provider.providers.ModernPotionMetaProvider";
        }
        if (className.startsWith("org.bukkit.craftbukkit.v1_21_R5.")) {
            return MappingsReader.getIntermedClass("org.bukkit.craftbukkit." + className.substring(23 + NMS_VERSION.length() + 1));
        }
        if (className.startsWith("org.bukkit.craftbukkit.CraftServer.")) {
            return MappingsReader.getIntermedClass(className.replace("org.bukkit.craftbukkit.CraftServer.", "org.bukkit.craftbukkit."));
        }
        if (className.startsWith("net.minecraft.server.v1_21_R5.")) {
            return MappingsReader.getIntermedClass(className.replace("net.minecraft.server.v1_21_R5.", "net.minecraft.server."));
        }
        if (className.startsWith("net.minecraft.") && !className.startsWith("class_")) {
            return MappingsReader.getIntermedClass(className);
        }
        if (className.startsWith("org.bukkit.craftbukkit.")) {
            return MappingsReader.getIntermedClass(className);
        }
        if (className.startsWith("net.minecraft.server.CraftServer.")) {
            return MappingsReader.getIntermedClass(className.replace("net.minecraft.server.CraftServer.", "net.minecraft.server."));
        }
        return className;
    }

    public static Class<?> getClassForName(String className) throws ClassNotFoundException {
        if (className.contains("LegacyPotionMetaProvider")) {
            System.out.println("Change: " + className);
            className = className.replace("LegacyPotionMetaProvider", "ModernPotionMetaProvider");
        }
        return ReflectionRemapper.getClassFromJPL(className);
    }

    public static Field getFieldByName(Class<?> calling, String f) throws ClassNotFoundException {
        try {
            Field field = calling.getDeclaredField(MappingsReader.getIntermedField_2(calling, f));
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                Field a = calling.getDeclaredField(MappingsReader.getIntermedField_2(calling, f));
                a.setAccessible(true);
                return a;
            }
            catch (NoSuchFieldException | SecurityException e1) {
                Class<?> whyIsAsmBroken = ReflectionRemapper.getClassFromJPL(ReflectionRemapper.getCallerClassName());
                try {
                    Field a = whyIsAsmBroken.getDeclaredField(MappingsReader.getIntermedField_2(whyIsAsmBroken, f));
                    a.setAccessible(true);
                    return a;
                }
                catch (NoSuchFieldException | SecurityException e2) {
                    if (f.contains("B_STATS_VERSION")) {
                        return ReflectionRemapper.getBstatsVersionField();
                    }
                    e2.printStackTrace();
                    return null;
                }
            }
        }
    }

    public static Field getBstatsVersionField() {
        Field f = null;
        int i = 0;
        for (Class service : Bukkit.getServicesManager().getKnownServices()) {
            if (i < BV_CALLED) {
                ++i;
                continue;
            }
            try {
                f = service.getField("B_STATS_VERSION");
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        ++BV_CALLED;
        return f;
    }

    public static Field getDeclaredFieldByName(Class<?> calling, String f) throws ClassNotFoundException, NoSuchFieldException {
        try {
            return calling.getDeclaredField(MappingsReader.getIntermedField_2(calling, f));
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                Field a = calling.getDeclaredField(MappingsReader.getIntermedField_2(calling, f));
                a.setAccessible(true);
                return a;
            }
            catch (NoSuchFieldException | SecurityException e1) {
                Class<?> whyIsAsmBroken = ReflectionRemapper.getClassFromJPL(ReflectionRemapper.getCallerClassName());
                if (f.contains("connectedChannels")) {
                    Field a = class_3242.class.getDeclaredField("connections");
                    a.setAccessible(true);
                    return a;
                }
                if (null == whyIsAsmBroken) {
                    System.out.println("CALLING: " + calling.getName() + ", F: " + f);
                    return null;
                }
                Field a = whyIsAsmBroken.getDeclaredField(MappingsReader.getIntermedField_2(whyIsAsmBroken, f));
                a.setAccessible(true);
                return a;
            }
        }
    }

    public static CraftServer getCraftServer() {
        return CraftServer.INSTANCE;
    }

    public static MinecraftServer getNmsServer() {
        return CraftServer.server;
    }

    public static Method[] getMethods(Class<?> calling) {
        Method[] r = calling.getMethods();
        if (calling.getSimpleName().contains("MinecraftServer")) {
            Method[] nr = new Method[r.length + 1];
            for (int i = 0; i < r.length; ++i) {
                nr[i] = r[i];
            }
            try {
                nr[r.length] = ReflectionRemapper.class.getMethod("getNmsServer", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            return nr;
        }
        return r;
    }

    @Deprecated
    public static Class<?> getClassFromJPL(String name) {
        try {
            SimplePluginManager pm = (SimplePluginManager)Bukkit.getPluginManager();
            Field fa = SimplePluginManager.class.getDeclaredField("fileAssociations");
            fa.setAccessible(true);
            Map pl = (Map)fa.get(pm);
            JavaPluginLoader jpl = null;
            for (PluginLoader loader : pl.values()) {
                if (!(loader instanceof JavaPluginLoader)) continue;
                jpl = (JavaPluginLoader)loader;
                break;
            }
            Method fc = JavaPluginLoader.class.getDeclaredMethod("getClassByName", String.class);
            fc.setAccessible(true);
            return (Class)fc.invoke((Object)jpl, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            CardboardMod.LOGGER.warning("SOMETHING EVERY WRONG! PLEASE REPORT THE EXCEPTION BELOW TO BUKKIT4FABRIC:");
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static JavaPluginLoader getFirstJPL() {
        try {
            SimplePluginManager pm = (SimplePluginManager)Bukkit.getPluginManager();
            if (null == pm) {
                System.out.println(" NULL PM ");
            }
            Field fa = SimplePluginManager.class.getDeclaredField("fileAssociations");
            fa.setAccessible(true);
            Map pl = (Map)fa.get(pm);
            JavaPluginLoader jpl = null;
            for (PluginLoader loader : pl.values()) {
                if (!(loader instanceof JavaPluginLoader)) continue;
                jpl = (JavaPluginLoader)loader;
                break;
            }
            return jpl;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            CardboardMod.LOGGER.warning("SOMETHING EVERY WRONG! PLEASE REPORT THE EXCEPTION BELOW TO CARDBOARD:");
            e.printStackTrace();
            return null;
        }
    }

    public static String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(ReflectionRemapper.class.getName()) || ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            return ste.getClassName();
        }
        return null;
    }

    public static String getPackageName(Package pkage) {
        String name = pkage.getName();
        if (name.startsWith("org.bukkit.craftbukkit")) {
            name = name.replace("org.bukkit.craftbukkit", "org.bukkit.craftbukkit.v1_21_R5");
        }
        return name;
    }

    public static String getClassName(Class<?> clazz) {
        String name = clazz.getName();
        if (name.startsWith("org.bukkit.craftbukkit")) {
            name = name.replace("org.bukkit.craftbukkit", "org.bukkit.craftbukkit.v1_21_R5");
        }
        return name;
    }

    public static String getCanonicalName(Class<?> clazz) {
        String name = clazz.getName();
        if (name.startsWith("org.bukkit.craftbukkit")) {
            name = name.replace("org.bukkit.craftbukkit", "org.bukkit.craftbukkit.v1_21_R5");
        }
        return name;
    }

    public static String getMinecraftServerVersion() {
        return class_155.method_16673().comp_4025();
    }

    static {
        BV_CALLED = 0;
    }
}

