/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.simpleshulkerpreview.container;

import com.bvengo.simpleshulkerpreview.SimpleShulkerPreviewMod;
import com.bvengo.simpleshulkerpreview.config.CustomNameOption;
import com.bvengo.simpleshulkerpreview.container.ContainerContentsType;
import com.bvengo.simpleshulkerpreview.container.ContainerType;
import com.bvengo.simpleshulkerpreview.container.ItemStackManager;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class ContainerManager {
    private final class_1799 containerStack;
    private final class_9323 containerComponents;
    private final String containerId;
    private boolean isContainerSupported;
    private ContainerType containerType;
    private ContainerContentsType containerContentsType;

    public ContainerManager(class_1799 containerStack) {
        this.containerStack = containerStack;
        this.containerId = containerStack.method_41409().method_55840();
        this.containerComponents = containerStack.method_57353();
        this.setContainerContentsType();
        this.setContainerType();
        this.setContainerSupported();
    }

    public class_1799 getDisplayStack() {
        Iterable itemIterable;
        if (!this.isContainerSupported) {
            return null;
        }
        class_1799 displayStack = ItemStackManager.getItemFromCustomName(this.containerStack);
        if (displayStack != null || SimpleShulkerPreviewMod.CONFIGS.customName == CustomNameOption.ALWAYS) {
            return displayStack;
        }
        switch (this.containerContentsType) {
            case CONTAINER: {
                class_9288 containerComponent = (class_9288)this.containerStack.method_58694(class_9334.field_49622);
                itemIterable = containerComponent.method_59715();
                break;
            }
            case BUNDLE: {
                class_9276 bundleComponent = (class_9276)this.containerStack.method_58694(class_9334.field_49650);
                itemIterable = bundleComponent.method_59708();
                break;
            }
            default: {
                return null;
            }
        }
        return ItemStackManager.getDisplayStackFromIterable(itemIterable);
    }

    public int getStackSize() {
        return this.containerStack.method_7947();
    }

    public Fraction getCapacity() {
        Fraction capacity;
        switch (this.containerContentsType) {
            case CONTAINER: {
                Fraction fraction = this.getContainerCapacity();
                break;
            }
            case BUNDLE: {
                Fraction fraction = this.getBundleCapacity();
                break;
            }
            default: {
                Fraction fraction = capacity = Fraction.ZERO;
            }
        }
        if (capacity.compareTo(Fraction.ONE) > 0) {
            capacity = Fraction.ONE;
        }
        return capacity;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    private Fraction getContainerCapacity() {
        if (this.containerType != ContainerType.SHULKER_BOX) {
            return Fraction.ZERO;
        }
        return this.getShulkerCapacity();
    }

    private Fraction getShulkerCapacity() {
        class_9288 containerComponent = (class_9288)this.containerStack.method_58694(class_9334.field_49622);
        if (containerComponent == null) {
            return Fraction.ZERO;
        }
        Fraction maxItems = Fraction.getFraction((int)(SimpleShulkerPreviewMod.CONFIGS.shulkerInventoryOptions.getSize() * 64), (int)1);
        Fraction numItems = Fraction.ZERO;
        Iterable itemIterable = containerComponent.method_59714();
        for (class_1799 itemStack : itemIterable) {
            numItems = numItems.add(ItemStackManager.getItemCountEquivalent(itemStack));
        }
        return numItems.divideBy(maxItems);
    }

    private Fraction getBundleCapacity() {
        class_9276 bundleComponent = (class_9276)this.containerStack.method_58694(class_9334.field_49650);
        return bundleComponent.method_57428();
    }

    private void setContainerContentsType() {
        this.containerContentsType = this.containerComponents.method_57832(class_9334.field_49622) ? ContainerContentsType.CONTAINER : (this.containerComponents.method_57832(class_9334.field_49650) ? ContainerContentsType.BUNDLE : ContainerContentsType.NONE);
    }

    private void setContainerType() {
        this.containerType = this.containerContentsType == ContainerContentsType.NONE ? ContainerType.NONE : (this.containerId.matches("^minecraft:(.*_)?shulker_box$") ? ContainerType.SHULKER_BOX : (this.containerId.matches("^minecraft:(.*_)?bundle$") ? ContainerType.BUNDLE : ContainerType.OTHER));
    }

    private void setContainerSupported() {
        switch (this.containerType) {
            case SHULKER_BOX: {
                this.isContainerSupported = true;
                return;
            }
            case BUNDLE: {
                this.isContainerSupported = SimpleShulkerPreviewMod.CONFIGS.supportBundles;
                return;
            }
            case OTHER: {
                this.isContainerSupported = SimpleShulkerPreviewMod.CONFIGS.supportOtherContainers;
                return;
            }
        }
        this.isContainerSupported = false;
    }
}

