/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.simpleshulkerpreview.container;

import com.bvengo.simpleshulkerpreview.SimpleShulkerPreviewMod;
import com.bvengo.simpleshulkerpreview.config.CustomNameOption;
import com.bvengo.simpleshulkerpreview.config.IconDisplayOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class ItemStackManager {
    private static Map<ItemStackGrouper, Double> groupItemStacks(Iterable<class_1799> itemIterable) {
        return StreamSupport.stream(itemIterable.spliterator(), false).collect(Collectors.groupingBy(ItemStackGrouper::new, LinkedHashMap::new, Collectors.summingDouble(x -> ItemStackManager.getItemCountEquivalent(x).doubleValue())));
    }

    public static Fraction getItemFraction(class_1799 itemStack) {
        return Fraction.getFraction((int)itemStack.method_7947(), (int)itemStack.method_7914());
    }

    public static Fraction getItemCountEquivalent(class_1799 itemStack) {
        return ItemStackManager.getItemFraction(itemStack).multiplyBy(Fraction.getFraction((int)64, (int)1));
    }

    public static class_1799 getDisplayStackFromIterable(Iterable<class_1799> itemIterable) {
        int itemThreshold = SimpleShulkerPreviewMod.CONFIGS.stackSizeOptions.minStackSize * SimpleShulkerPreviewMod.CONFIGS.stackSizeOptions.minStackCount;
        Map<ItemStackGrouper, Double> groupedItems = ItemStackManager.groupItemStacks(itemIterable);
        Optional<Object> selected = switch (SimpleShulkerPreviewMod.CONFIGS.displayIcon) {
            default -> throw new MatchException(null, null);
            case IconDisplayOption.FIRST -> groupedItems.entrySet().stream().filter(entry -> (Double)entry.getValue() >= (double)itemThreshold).findFirst();
            case IconDisplayOption.LAST -> groupedItems.entrySet().stream().filter(entry -> (Double)entry.getValue() >= (double)itemThreshold).reduce((first, second) -> second);
            case IconDisplayOption.UNIQUE -> {
                if (groupedItems.size() != 1) {
                    yield Optional.empty();
                }
                yield groupedItems.entrySet().stream().filter(entry -> (Double)entry.getValue() >= (double)itemThreshold).findFirst();
            }
            case IconDisplayOption.MOST -> ItemStackManager.groupItemStacks(itemIterable).entrySet().stream().filter(entry -> (Double)entry.getValue() >= (double)itemThreshold).max(Map.Entry.comparingByValue());
            case IconDisplayOption.LEAST -> ItemStackManager.groupItemStacks(itemIterable).entrySet().stream().filter(entry -> (Double)entry.getValue() >= (double)itemThreshold).min(Map.Entry.comparingByValue());
        };
        return selected.map(Map.Entry::getKey).map(grouper -> grouper.itemStack).orElse(null);
    }

    public static class_1799 getItemFromCustomName(class_1799 itemStack) {
        if (SimpleShulkerPreviewMod.CONFIGS.customName == CustomNameOption.NEVER) {
            return null;
        }
        class_2561 customName = (class_2561)itemStack.method_57353().method_58694(class_9334.field_49631);
        if (customName == null) {
            return null;
        }
        class_2960 itemId = class_2960.method_12829((String)customName.getString());
        if (itemId == null) {
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
        if (item.equals(class_1802.field_8162)) {
            return null;
        }
        return new class_1799((class_1935)item);
    }

    private static String getSkullName(class_1799 itemStack) {
        class_9296 profileComponent = (class_9296)itemStack.method_58694(class_9334.field_49617);
        if (profileComponent == null) {
            return null;
        }
        return profileComponent.method_73317().orElse(null);
    }

    private static String getPotionType(class_1799 itemStack) {
        class_1844 potionComponent = (class_1844)itemStack.method_58694(class_9334.field_49651);
        if (potionComponent == null) {
            return null;
        }
        return potionComponent.method_64195("").getString();
    }

    private static class ItemStackGrouper {
        public final class_1799 itemStack;
        public String itemString;

        public ItemStackGrouper(class_1799 itemStack) {
            this.itemStack = itemStack;
            this.setItemString();
        }

        private void setItemString() {
            String potionType;
            String skullName;
            this.itemString = this.itemStack.method_7909().method_7876();
            if (this.itemStack.method_31574(class_1802.field_8575) && (skullName = ItemStackManager.getSkullName(this.itemStack)) != null) {
                this.itemString = this.itemString + "." + skullName;
            }
            if (this.itemStack.method_31574(class_1802.field_8574) && (potionType = ItemStackManager.getPotionType(this.itemStack)) != null) {
                this.itemString = this.itemString + "." + potionType;
            }
            if (SimpleShulkerPreviewMod.CONFIGS.groupEnchantment && this.itemStack.method_7942()) {
                this.itemString = this.itemString + ".enchanted";
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ItemStackGrouper otherGrouper = (ItemStackGrouper)obj;
            return this.itemString.equals(otherGrouper.itemString) && this.itemStack.method_7909().equals(otherGrouper.itemStack.method_7909());
        }

        public int hashCode() {
            return Objects.hash(this.itemString);
        }
    }
}

