/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.simpleshulkerpreview.positioners;

import com.bvengo.simpleshulkerpreview.SimpleShulkerPreviewMod;
import com.bvengo.simpleshulkerpreview.config.CapacityBarOptions;
import com.bvengo.simpleshulkerpreview.container.ContainerManager;
import com.bvengo.simpleshulkerpreview.positioners.OverlayRenderer;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.apache.commons.lang3.math.Fraction;

public class CapacityBarRenderer
extends OverlayRenderer {
    private static final int FULL_ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.33f, (float)0.33f);
    private static final int ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)0.44f, (float)0.53f, (float)1.0f);
    private Fraction capacity;
    private int xBackgroundStart;
    private int yBackgroundStart;
    private int xBackgroundEnd;
    private int yBackgroundEnd;
    private int xCapacityStart;
    private int yCapacityStart;
    private int xCapacityEnd;
    private int yCapacityEnd;
    private final CapacityBarOptions configs;

    public CapacityBarRenderer(ContainerManager containerParser, class_1799 stack, int x, int y) {
        super(stack, x, y);
        this.configs = SimpleShulkerPreviewMod.CONFIGS.capacityBarOptions;
        this.capacity = containerParser.getCapacity();
    }

    @Override
    protected boolean canDisplay() {
        return !(this.configs.hideWhenEmpty && this.capacity.compareTo(Fraction.ZERO) <= 0 || this.configs.hideWhenFull && this.capacity.compareTo(Fraction.ONE) >= 0);
    }

    @Override
    protected void calculatePositions() {
        int step = (int)((float)this.configs.length * this.capacity.floatValue());
        int shadowHeight = this.configs.displayShadow ? 1 : 0;
        this.xBackgroundStart = this.stackX + this.configs.translateX;
        this.yBackgroundStart = this.stackY + this.configs.translateY;
        switch (this.configs.direction) {
            case LEFT_TO_RIGHT: {
                this.xBackgroundEnd = this.xBackgroundStart + this.configs.length;
                this.yBackgroundEnd = this.yBackgroundStart + this.configs.width + shadowHeight;
                this.xCapacityStart = this.xBackgroundStart;
                this.yCapacityStart = this.yBackgroundStart;
                this.xCapacityEnd = this.xBackgroundStart + step;
                this.yCapacityEnd = this.yCapacityStart + this.configs.width;
                break;
            }
            case RIGHT_TO_LEFT: {
                this.xBackgroundEnd = this.xBackgroundStart + this.configs.length;
                this.yBackgroundEnd = this.yBackgroundStart + this.configs.width + shadowHeight;
                this.xCapacityStart = this.xBackgroundEnd - step;
                this.yCapacityStart = this.yBackgroundStart;
                this.xCapacityEnd = this.xBackgroundEnd;
                this.yCapacityEnd = this.yCapacityStart + this.configs.width;
                break;
            }
            case TOP_TO_BOTTOM: {
                this.xBackgroundEnd = this.xBackgroundStart + this.configs.width;
                this.yBackgroundEnd = this.yBackgroundStart + this.configs.length;
                this.xCapacityStart = this.xBackgroundStart;
                this.yCapacityStart = this.yBackgroundStart;
                this.xCapacityEnd = this.xBackgroundEnd;
                this.yCapacityEnd = this.yCapacityStart + step;
                break;
            }
            case BOTTOM_TO_TOP: {
                this.xBackgroundEnd = this.xBackgroundStart + this.configs.width;
                this.yBackgroundEnd = this.yBackgroundStart + this.configs.length;
                this.xCapacityStart = this.xBackgroundStart;
                this.yCapacityStart = this.yBackgroundEnd - step;
                this.xCapacityEnd = this.xBackgroundEnd;
                this.yCapacityEnd = this.yBackgroundEnd;
                break;
            }
            default: {
                String err = "Unexpected value for capacity direction: " + String.valueOf((Object)this.configs.direction);
                SimpleShulkerPreviewMod.LOGGER.error(err);
                throw new IllegalStateException(err);
            }
        }
    }

    @Override
    protected void render(class_332 context) {
        if (this.configs.displayShadow) {
            context.method_48196(class_10799.field_56879, this.xBackgroundStart, this.yBackgroundStart, this.xBackgroundEnd, this.yBackgroundEnd, -16777216);
        }
        int colour = this.capacity.compareTo(Fraction.ONE) == 0 ? FULL_ITEM_BAR_COLOR : ITEM_BAR_COLOR;
        context.method_48196(class_10799.field_56879, this.xCapacityStart, this.yCapacityStart, this.xCapacityEnd, this.yCapacityEnd, class_9848.method_61334((int)colour));
    }

    @Override
    public void renderOptional(class_332 context) {
        if (this.canDisplay()) {
            this.calculatePositions();
            this.render(context);
        }
    }
}

