/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.simpleshulkerpreview.positioners;

import com.bvengo.simpleshulkerpreview.SimpleShulkerPreviewMod;
import com.bvengo.simpleshulkerpreview.access.DrawContextAccess;
import com.bvengo.simpleshulkerpreview.config.IconPositionOptions;
import com.bvengo.simpleshulkerpreview.container.ContainerManager;
import com.bvengo.simpleshulkerpreview.positioners.OverlayRenderer;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class IconRenderer
extends OverlayRenderer {
    IconPositionOptions iconPositionOptions;
    public float scale;
    public float xOffset;
    public float yOffset;

    public IconRenderer(ContainerManager containerParser, class_1799 displayStack, int x, int y) {
        super(displayStack, x, y);
        this.setPositionOptions(containerParser);
    }

    private void setPositionOptions(ContainerManager containerParser) {
        switch (containerParser.getContainerType()) {
            case SHULKER_BOX: {
                this.iconPositionOptions = containerParser.getStackSize() > 1 ? SimpleShulkerPreviewMod.CONFIGS.iconPositionOptionsStacked : SimpleShulkerPreviewMod.CONFIGS.iconPositionOptionsGeneral;
                break;
            }
            case BUNDLE: {
                this.iconPositionOptions = SimpleShulkerPreviewMod.CONFIGS.iconPositionOptionsBundle;
                break;
            }
            case OTHER: {
                this.iconPositionOptions = SimpleShulkerPreviewMod.CONFIGS.iconPositionOptionsGeneral;
                break;
            }
        }
    }

    @Override
    protected void calculatePositions() {
        this.xOffset = (float)this.iconPositionOptions.translateX - 8.0f;
        this.yOffset = (float)this.iconPositionOptions.translateY - 8.0f;
        this.scale = this.iconPositionOptions.scale;
    }

    @Override
    protected void render(class_332 context) {
        ((DrawContextAccess)context).simple_shulker_preview$setAdjustSize(true);
        context.method_51445(this.stack, this.stackX, this.stackY);
        ((DrawContextAccess)context).simple_shulker_preview$setAdjustSize(false);
    }

    @Override
    public void renderOptional(class_332 context) {
        if (this.canDisplay()) {
            this.calculatePositions();
            this.render(context);
        }
    }

    @Override
    protected boolean canDisplay() {
        return this.stack != null && this.stack.method_7909() != null;
    }
}

