/*
 * Decompiled with CFR 0.152.
 */
package classicgen.zombies_improved;

import classicgen.zombies_improved.Config;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="zombies_improved")
public class Zombies_improved {
    public static final String MODID = "zombies_improved";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, Long> infectedPlayers = new HashMap<UUID, Long>();
    public static final Set<UUID> justZombified = new HashSet<UUID>();
    public static final Set<UUID> infectionProtected = new HashSet<UUID>();
    public static final List<LivingEntity> allZombies = new ArrayList<LivingEntity>();

    public Zombies_improved() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            this.improveZombie((PathfinderMob)zombie);
            allZombies.add((LivingEntity)zombie);
        }
        if ((entity = event.getEntity()) instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)entity;
            this.improveZombie((PathfinderMob)zombieVillager);
            allZombies.add((LivingEntity)zombieVillager);
        }
    }

    private void improveZombie(PathfinderMob zombie) {
        zombie.m_21553_(true);
        zombie.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)zombie, difficulty -> true));
        zombie.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal(zombie, 1.2, false));
        zombie.f_21345_.m_25352_(3, (Goal)new FleeSunGoal(zombie, 1.0));
        zombie.f_21345_.m_25352_(4, (Goal)new ZombieSeekShelterGoal((Mob)zombie));
        zombie.f_21345_.m_25352_(5, (Goal)new ZombieHordeGoal((Mob)zombie));
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity;
        if ((event.getSource().m_7639_() instanceof Zombie || event.getSource().m_7639_() instanceof ZombieVillager) && (livingEntity = event.getEntity()) instanceof Player && !infectedPlayers.containsKey((player = (Player)livingEntity).m_20148_()) && !infectionProtected.contains(player.m_20148_()) && player.m_9236_().f_46441_.m_188500_() < (Double)Config.INFECTION_CHANCE.get()) {
            infectedPlayers.put(player.m_20148_(), System.currentTimeMillis());
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20 * (Integer)Config.FIRST_STAGE_SECONDS.get(), 0, false, false, true));
        }
    }

    @SubscribeEvent
    public void onItemEat(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Item usedItem = event.getItem().m_41720_();
            if (usedItem == Items.f_42436_ || usedItem == Items.f_42437_) {
                boolean infected = infectedPlayers.containsKey(player.m_20148_());
                boolean zombifying = justZombified.contains(player.m_20148_());
                if (infected || zombifying) {
                    infectedPlayers.remove(player.m_20148_());
                    justZombified.remove(player.m_20148_());
                    infectionProtected.add(player.m_20148_());
                    player.m_21195_(MobEffects.f_19604_);
                    player.m_21195_(MobEffects.f_19610_);
                    player.m_213846_((Component)Component.m_237113_((String)"\u0412\u044b \u0441\u043f\u0430\u0441\u043b\u0438\u0441\u044c \u043e\u0442 \u0437\u043e\u043c\u0431\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438!"));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (infectedPlayers.containsKey(player.m_20148_())) {
            long infectionTime = infectedPlayers.get(player.m_20148_());
            long now = System.currentTimeMillis();
            int first = (Integer)Config.FIRST_STAGE_SECONDS.get() * 1000;
            int second = (Integer)Config.SECOND_STAGE_SECONDS.get() * 1000;
            if (now - infectionTime < (long)first) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 40, 0, false, false, true));
            } else if (now - infectionTime < (long)(first + second)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 40, 0, false, false, true));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false, true));
            } else if (!justZombified.contains(player.m_20148_())) {
                justZombified.add(player.m_20148_());
                infectedPlayers.remove(player.m_20148_());
            }
        }
        if (justZombified.contains(player.m_20148_())) {
            ZombieApocalypseHelper.spawnZombieFromPlayer(player, player.m_9236_());
            player.m_6074_();
            justZombified.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (((Boolean)Config.SPAWN_ZOMBIE_ON_KILL.get()).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            Entity killer = event.getSource().m_7639_();
            if ((killer instanceof Zombie || killer instanceof ZombieVillager) && !justZombified.contains(player.m_20148_())) {
                justZombified.add(player.m_20148_());
                ZombieApocalypseHelper.spawnZombieFromPlayer(player, player.m_9236_());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && justZombified.contains((player = (Player)livingEntity).m_20148_())) {
            event.getDrops().removeIf(item -> item.m_32055_().m_41720_() instanceof PlayerHeadItem);
        }
    }

    public static class ZombieSeekShelterGoal
    extends Goal {
        private final Mob zombie;

        public ZombieSeekShelterGoal(Mob zombie) {
            this.zombie = zombie;
        }

        public boolean m_8036_() {
            Level level = this.zombie.m_9236_();
            BlockPos pos = this.zombie.m_20183_();
            return !level.f_46443_ && this.zombie.m_6084_() && level.m_46461_() && level.m_45527_(pos) && !this.zombie.m_20071_();
        }

        public void m_8056_() {
            BlockPos pos = this.zombie.m_20183_();
            Level level = this.zombie.m_9236_();
            for (int y = pos.m_123342_(); y > pos.m_123342_() - 4; --y) {
                BlockPos check = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                if (!level.m_8055_(check).m_60713_(Blocks.f_49990_)) continue;
                this.zombie.m_21573_().m_26519_((double)check.m_123341_(), (double)check.m_123342_(), (double)check.m_123343_(), 1.0);
                return;
            }
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    BlockPos check = pos.m_7918_(dx, 0, dz);
                    if (level.m_45527_(check) || !level.m_8055_(check).m_60795_()) continue;
                    this.zombie.m_21573_().m_26519_((double)check.m_123341_(), (double)check.m_123342_(), (double)check.m_123343_(), 1.0);
                    return;
                }
            }
        }
    }

    public static class ZombieHordeGoal
    extends Goal {
        private final Mob zombie;

        public ZombieHordeGoal(Mob zombie) {
            this.zombie = zombie;
        }

        public boolean m_8036_() {
            for (LivingEntity other : allZombies) {
                Mob mob;
                LivingEntity livingEntity;
                if (other == this.zombie || !(other instanceof Mob) || !((livingEntity = (mob = (Mob)other).m_5448_()) instanceof Player)) continue;
                Player p = (Player)livingEntity;
                if (!(this.zombie.m_20270_((Entity)other) < 16.0f) || this.zombie.m_5448_() != null) continue;
                this.zombie.m_6710_((LivingEntity)p);
                return true;
            }
            return false;
        }
    }

    public static class ZombieApocalypseHelper {
        public static void spawnZombieFromPlayer(Player player, Level level) {
            Zombie zombie = new Zombie(level);
            zombie.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), 0.0f);
            zombie.m_21553_(true);
            ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
            head.m_41784_().m_128359_("SkullOwner", player.m_7755_().getString());
            zombie.m_8061_(EquipmentSlot.HEAD, head);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack s;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (s = player.m_6844_(slot)).m_41619_()) continue;
                zombie.m_8061_(slot, s.m_41777_());
            }
            ItemStack main = player.m_21205_();
            if (!main.m_41619_()) {
                zombie.m_8061_(EquipmentSlot.MAINHAND, main.m_41777_());
            }
            level.m_7967_((Entity)zombie);
        }
    }

    @Mod.EventBusSubscriber(modid="zombies_improved", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Zombies Improved: client setup, Player name: {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

