/*
 * Decompiled with CFR 0.152.
 */
package core.paper.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.paper.cache.PlayerCache;
import core.paper.command.ComponentCommandExceptionType;
import core.paper.command.WrappedArgumentType;
import core.paper.command.argument.EnumArgumentType;
import core.paper.command.argument.codec.EnumStringCodec;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Deprecated(forRemoval=true, since="2.3.0")
public final class CustomArgumentTypes {
    private static final ComponentCommandExceptionType NO_PLAYER_FOUND = new ComponentCommandExceptionType((Component)Component.translatable((String)"argument.entity.notfound.player"));

    @Deprecated(forRemoval=true, since="2.3.0")
    public static <T extends Enum<T>> ArgumentType<T> enumType(Class<T> enumClass) {
        return EnumArgumentType.of(enumClass, EnumStringCodec.hyphen());
    }

    public static ArgumentType<OfflinePlayer> cachedOfflinePlayer() {
        return new WrappedArgumentType<String, OfflinePlayer>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            try (Stream<String> players = PlayerCache.getOfflinePlayers().map(OfflinePlayer::getName).filter(Objects::nonNull).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).limit(100L);){
                players.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.build();
        }));
    }

    public static ArgumentType<Player> playerExact() {
        return new WrappedArgumentType<String, Player>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        }));
    }

    public static ArgumentType<Player> player() {
        return new WrappedArgumentType<String, Player>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            Player player = Bukkit.getPlayer((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        }));
    }
}

