/*
 * Decompiled with CFR 0.152.
 */
package core.paper.version;

import core.paper.version.PluginVersionChecker;
import core.version.Version;
import core.version.github.GitHubVersionChecker;
import core.version.github.Release;
import io.papermc.paper.ServerBuildInfo;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class PaperGitHubVersionChecker<V extends Version>
extends GitHubVersionChecker<V>
implements PluginVersionChecker {
    private final V versionRunning;
    private final Plugin plugin;

    public PaperGitHubVersionChecker(Plugin plugin, String owner, String repository) {
        super(owner, repository);
        this.versionRunning = (Version)Objects.requireNonNull(this.parseVersion(plugin.getPluginMeta().getVersion()), "Failed to parse plugin version running");
        this.plugin = plugin;
    }

    @Override
    public void checkLatestVersion() {
        ((CompletableFuture)this.retrieveLatestVersion().thenAccept(this::printVersionInfo)).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("There are no public releases for this plugin yet");
            return null;
        });
    }

    @Override
    public void checkVersion() {
        ((CompletableFuture)this.retrieveLatestSupportedVersion().thenAccept(optional -> optional.ifPresentOrElse(this::printVersionInfo, () -> ((CompletableFuture)this.retrieveLatestVersion().thenAccept(this::printUnsupportedInfo)).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("There are no public releases for this plugin yet");
            return null;
        })))).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Version check failed", throwable);
            return null;
        });
    }

    private void printUnsupportedInfo(V version) {
        ComponentLogger logger = this.plugin.getComponentLogger();
        ServerBuildInfo buildInfo = ServerBuildInfo.buildInfo();
        if (version.equals(this.versionRunning)) {
            logger.warn("{} seems to be unsupported by {} version {}", new Object[]{buildInfo.minecraftVersionId(), this.plugin.getName(), this.versionRunning});
        } else if (version.compareTo(this.versionRunning) > 0) {
            logger.warn("A new version for {} is available but {} seems to be unsupported", (Object)this.plugin.getName(), (Object)buildInfo.minecraftVersionId());
            logger.warn("You are running version {}, the latest version is {}", this.versionRunning, version);
            logger.warn("Update at https://github.com/{}/{}", (Object)this.getOwner(), (Object)this.getRepository());
            logger.warn("Do not test in production and always make backups before updating");
        } else {
            logger.warn("You are running a snapshot version of {}", (Object)this.plugin.getName());
        }
    }

    private void printVersionInfo(V version) {
        ComponentLogger logger = this.plugin.getComponentLogger();
        if (version.equals(this.versionRunning)) {
            logger.info("You are running the latest version of {}", (Object)this.plugin.getName());
        } else if (version.compareTo(this.versionRunning) > 0) {
            logger.warn("An update for {} is available", (Object)this.plugin.getName());
            logger.warn("You are running version {}, the latest version is {}", this.versionRunning, version);
            logger.warn("Update at https://github.com/{}/{}", (Object)this.getOwner(), (Object)this.getRepository());
            logger.warn("Do not test in production and always make backups before updating");
        } else {
            logger.warn("You are running a snapshot version of {}", (Object)this.plugin.getName());
        }
    }

    @Override
    public boolean isSupported(Release version) {
        return true;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public V getVersionRunning() {
        return this.versionRunning;
    }
}

