/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.controller.chat;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.chat.ChatProfile;
import net.thenextlvl.service.model.chat.GroupManagerChatProfile;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GroupManagerChatController
implements ChatController {
    private final GroupManager groupManager = (GroupManager)JavaPlugin.getPlugin(GroupManager.class);

    @Override
    public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player) {
        return this.getProfile(player).map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player, World world) {
        return this.getProfile(player, world).map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid) {
        return this.getProfile(uuid).map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid, World world) {
        return this.getProfile(uuid, world).map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    @Override
    public Optional<ChatProfile> getProfile(OfflinePlayer player) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getDefaultWorld();
        return this.getProfile((WorldDataHolder)holder, player.getUniqueId(), player.getName());
    }

    @Override
    public Optional<ChatProfile> getProfile(OfflinePlayer player, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return this.getProfile((WorldDataHolder)holder, player.getUniqueId(), player.getName());
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getDefaultWorld();
        return this.getProfile((WorldDataHolder)holder, uuid, null);
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return this.getProfile((WorldDataHolder)holder, uuid, null);
    }

    private Optional<ChatProfile> getProfile(@Nullable WorldDataHolder holder, UUID uuid, @Nullable String name) {
        if (holder == null) {
            return Optional.empty();
        }
        User user = name != null ? holder.getUser(uuid.toString(), name) : holder.getUser(uuid.toString());
        return user != null ? Optional.of(new GroupManagerChatProfile(user, holder)) : Optional.empty();
    }

    @Override
    public Plugin getPlugin() {
        return this.groupManager;
    }

    @Override
    public String getName() {
        return "GroupManager Chat";
    }
}

