/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.controller.group;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.group.GroupManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.model.group.LuckPermsGroup;
import net.thenextlvl.service.model.permission.LuckPermsPermissionHolder;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LuckPermsGroupController
implements GroupController {
    private final LuckPerms luckPerms = LuckPermsProvider.get();
    private final Plugin plugin;

    public LuckPermsGroupController(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> createGroup(String name) {
        return this.luckPerms.getGroupManager().createAndLoadGroup(name).thenApply(group -> new LuckPermsGroup((Group)group, group.getQueryOptions(), null));
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> createGroup(String name, World world) {
        return this.luckPerms.getGroupManager().createAndLoadGroup(name).thenApply(group -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsGroup((Group)group, context, null);
        });
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> loadGroup(String name) {
        return this.luckPerms.getGroupManager().loadGroup(name).thenCompose(optional -> optional.map(group -> new LuckPermsGroup((Group)group, group.getQueryOptions(), null)).map(CompletableFuture::completedFuture).orElse(CompletableFuture.completedFuture(null)));
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> loadGroup(String name, World world) {
        return this.luckPerms.getGroupManager().loadGroup(name).thenCompose(optional -> optional.map(group -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsGroup((Group)group, context, world);
        }).map(CompletableFuture::completedFuture).orElse(CompletableFuture.completedFuture(null)));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(UUID uuid) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> new LuckPermsPermissionHolder((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(UUID uuid, World world) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> {
            QueryOptions options = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsPermissionHolder((User)user, options);
        });
    }

    @Override
    public CompletableFuture<Set<net.thenextlvl.service.api.group.Group>> loadGroups() {
        return this.luckPerms.getGroupManager().loadAllGroups().thenApply(unused -> this.getGroups());
    }

    @Override
    public CompletableFuture<Set<net.thenextlvl.service.api.group.Group>> loadGroups(World world) {
        return this.luckPerms.getGroupManager().loadAllGroups().thenApply(unused -> this.getGroups(world));
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(net.thenextlvl.service.api.group.Group group) {
        CompletionStage<Boolean> completionStage;
        if (!(group instanceof LuckPermsGroup)) {
            completionStage = this.deleteGroup(group.getName());
        } else {
            LuckPermsGroup luckPermsGroup = (LuckPermsGroup)group;
            completionStage = this.luckPerms.getGroupManager().deleteGroup(luckPermsGroup.group()).thenApply(none -> true);
        }
        return completionStage;
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(net.thenextlvl.service.api.group.Group group, World world) {
        return this.deleteGroup(group);
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(String name) {
        return this.luckPerms.getGroupManager().loadGroup(name).thenApply(optional -> optional.map(arg_0 -> ((GroupManager)this.luckPerms.getGroupManager()).deleteGroup(arg_0)).isPresent());
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(String name, World world) {
        return this.deleteGroup(name);
    }

    @Override
    public Optional<net.thenextlvl.service.api.group.Group> getGroup(String name) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(name)).map(group -> new LuckPermsGroup((Group)group, group.getQueryOptions(), null));
    }

    @Override
    public Optional<net.thenextlvl.service.api.group.Group> getGroup(String name, World world) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(name)).map(group -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsGroup((Group)group, context, null);
        });
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(UUID uuid) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> new LuckPermsPermissionHolder((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(UUID uuid, World world) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsPermissionHolder((User)user, context);
        });
    }

    @Override
    public Set<net.thenextlvl.service.api.group.Group> getGroups() {
        return this.luckPerms.getGroupManager().getLoadedGroups().stream().map(group -> new LuckPermsGroup((Group)group, group.getQueryOptions(), null)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<net.thenextlvl.service.api.group.Group> getGroups(World world) {
        QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
        return this.luckPerms.getGroupManager().getLoadedGroups().stream().map(group -> new LuckPermsGroup((Group)group, context, world)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return "LuckPerms Groups";
    }
}

