/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.listener;

import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.wrapper.VaultChatServiceWrapper;
import net.thenextlvl.service.wrapper.VaultEconomyServiceWrapper;
import net.thenextlvl.service.wrapper.VaultPermissionServiceWrapper;
import net.thenextlvl.service.wrapper.Wrapper;
import net.thenextlvl.service.wrapper.service.BankServiceWrapper;
import net.thenextlvl.service.wrapper.service.ChatServiceWrapper;
import net.thenextlvl.service.wrapper.service.EconomyServiceWrapper;
import net.thenextlvl.service.wrapper.service.PermissionServiceWrapper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServiceListener
implements Listener {
    private final ServicePlugin plugin;

    public ServiceListener(ServicePlugin plugin) {
        this.plugin = plugin;
        this.getServicesManager().getKnownServices().forEach(aClass -> this.getServicesManager().getRegistrations(aClass).forEach(this::loadWrapper));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        String type;
        Object provider = event.getProvider().getProvider();
        String string = provider instanceof Controller ? "controller" : (type = provider instanceof Wrapper ? "service wrapper" : null);
        if (type != null) {
            this.plugin.getComponentLogger().info("Unregistered {} for {} - {} ({})", new Object[]{type, event.getProvider().getPlugin().getName(), event.getProvider().getProvider().getClass().getName(), event.getProvider().getPriority().name()});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onServiceRegister(ServiceRegisterEvent event) {
        this.loadWrapper(event.getProvider());
    }

    private void loadWrapper(RegisteredServiceProvider<?> provider) {
        if (provider.getProvider() instanceof Wrapper) {
            return;
        }
        if (provider.getProvider() instanceof PermissionController) {
            this.loadVaultPermissionWrapper(provider);
        } else if (provider.getProvider() instanceof Permission) {
            this.loadServicePermissionWrapper(provider);
        } else if (provider.getProvider() instanceof EconomyController) {
            this.loadVaultEconomyWrapper(provider);
        } else if (provider.getProvider() instanceof Economy) {
            this.loadServiceEconomyWrapper(provider);
        } else if (provider.getProvider() instanceof ChatController) {
            this.loadVaultChatWrapper(provider);
        } else if (provider.getProvider() instanceof Chat) {
            this.loadServiceChatWrapper(provider);
        }
    }

    private void loadServicePermissionWrapper(RegisteredServiceProvider<Permission> provider) {
        PermissionServiceWrapper wrapper = new PermissionServiceWrapper((Permission)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(PermissionController.class, (Object)wrapper, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered permission service wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((Permission)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private void loadServiceEconomyWrapper(RegisteredServiceProvider<Economy> provider) {
        EconomyServiceWrapper wrapper = new EconomyServiceWrapper((Economy)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(EconomyController.class, (Object)wrapper, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered economy service wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((Economy)provider.getProvider()).getName(), provider.getPriority().name()});
        if (!((Economy)provider.getProvider()).hasBankSupport()) {
            return;
        }
        BankServiceWrapper banks = new BankServiceWrapper((Economy)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(BankController.class, (Object)banks, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered bank service wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((Economy)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private void loadServiceChatWrapper(RegisteredServiceProvider<Chat> provider) {
        ChatServiceWrapper wrapper = new ChatServiceWrapper((Chat)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(ChatController.class, (Object)wrapper, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered chat service wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((Chat)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private void loadVaultPermissionWrapper(RegisteredServiceProvider<PermissionController> provider) {
        GroupController groupController = (GroupController)this.getServicesManager().load(GroupController.class);
        VaultPermissionServiceWrapper wrapper = new VaultPermissionServiceWrapper(groupController, (PermissionController)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(Permission.class, (Object)wrapper, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered vault permission wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((PermissionController)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private void loadVaultEconomyWrapper(RegisteredServiceProvider<EconomyController> provider) {
        VaultEconomyServiceWrapper wrapper = new VaultEconomyServiceWrapper((EconomyController)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(Economy.class, (Object)wrapper, provider.getPlugin(), provider.getPriority());
        this.plugin.getComponentLogger().info("Registered vault economy wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((EconomyController)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private void loadVaultChatWrapper(RegisteredServiceProvider<ChatController> provider) {
        GroupController groupController = (GroupController)this.getServicesManager().load(GroupController.class);
        Permission permission = (Permission)this.getServicesManager().load(Permission.class);
        if (permission == null) {
            this.plugin.getComponentLogger().warn("Failed to register chat service wrapper, no permission service found");
            return;
        }
        VaultChatServiceWrapper wrapper = new VaultChatServiceWrapper(permission, groupController, (ChatController)provider.getProvider(), provider.getPlugin());
        this.getServicesManager().register(Chat.class, (Object)wrapper, provider.getPlugin(), ServicePriority.Highest);
        this.plugin.getComponentLogger().info("Registered vault chat wrapper for {} - {} ({})", new Object[]{provider.getPlugin().getName(), ((ChatController)provider.getProvider()).getName(), provider.getPriority().name()});
    }

    private ServicesManager getServicesManager() {
        return this.plugin.getServer().getServicesManager();
    }
}

