/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.model.chat;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thenextlvl.service.api.chat.ChatProfile;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record GroupManagerChatProfile(User user, WorldDataHolder holder) implements ChatProfile
{
    @Override
    public Optional<String> getDisplayName() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getName() {
        return Optional.of(this.user().getLastName());
    }

    @Override
    public Optional<String> getPrefix(int priority) {
        return Optional.ofNullable(this.holder().getPermissionsHandler().getUserPrefix(this.user().getLastName()));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getPrefixes() {
        return this.getPrefix().map(prefix -> Map.of(0, prefix)).orElseGet(Map::of);
    }

    @Override
    public Optional<String> getPrimaryGroup() {
        return Optional.of(this.user().getGroup().getName());
    }

    @Override
    public Optional<String> getSuffix(int priority) {
        return Optional.ofNullable(this.holder().getPermissionsHandler().getUserSuffix(this.user().getLastName()));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getSuffixes() {
        return this.getSuffix().map(suffix -> Map.of(0, suffix)).orElseGet(Map::of);
    }

    @Override
    public @Unmodifiable Set<String> getGroups() {
        return this.user().getSaveSubGroupsList().stream().map(arg_0 -> ((WorldDataHolder)this.holder()).getGroup(arg_0)).filter(Objects::nonNull).map(Group::getName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean setDisplayName(@Nullable String displayName) {
        return false;
    }

    @Override
    public boolean setPrefix(@Nullable String prefix, int priority) {
        if (prefix == null) {
            return this.removeInfoNode("prefix");
        }
        return this.setInfoNode("prefix", prefix);
    }

    @Override
    public boolean setSuffix(@Nullable String suffix, int priority) {
        if (suffix == null) {
            return this.removeInfoNode("suffix");
        }
        return this.setInfoNode("suffix", suffix);
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<@Nullable String, @Nullable T> mapper) {
        return Optional.ofNullable(mapper.apply(this.user().getVariables().getVarString(key)));
    }

    @Override
    public boolean removeInfoNode(String key) {
        if (!this.hasInfoNode(key)) {
            return false;
        }
        this.user().getVariables().removeVar(key);
        return true;
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        this.user().getVariables().addVar(key, (Object)value);
        return true;
    }

    @Override
    public boolean hasInfoNode(String key) {
        return this.user().getVariables().hasVar(key);
    }
}

