/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.model.hologram.fancy;

import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.util.Objects;
import java.util.Optional;
import net.thenextlvl.service.api.hologram.HologramDisplay;
import net.thenextlvl.service.api.hologram.HologramLine;
import net.thenextlvl.service.api.hologram.LineType;
import net.thenextlvl.service.model.hologram.fancy.FancyHologramDisplay;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class FancyHologramLine<D extends DisplayHologramData, T>
implements HologramLine<T> {
    public final D data;

    protected FancyHologramLine(D data) {
        this.data = data;
    }

    @Override
    public LineType getType() {
        return switch (this.data.getType()) {
            default -> throw new MatchException(null, null);
            case HologramType.TEXT -> LineType.TEXT;
            case HologramType.ITEM -> LineType.ITEM;
            case HologramType.BLOCK -> LineType.BLOCK;
        };
    }

    @Override
    public Optional<HologramDisplay> getDisplay() {
        return Optional.of(new FancyHologramDisplay((DisplayHologramData)this.data));
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    @Override
    public double getOffsetX() {
        return this.data.getTranslation().x();
    }

    @Override
    public double getOffsetY() {
        return this.data.getTranslation().y();
    }

    @Override
    public double getOffsetZ() {
        return this.data.getTranslation().z();
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    public void setOffsetX(double offsetX) {
        this.data.setTranslation(new Vector3f((float)offsetX, (float)this.getOffsetY(), (float)this.getOffsetZ()));
    }

    @Override
    public void setOffsetY(double offsetY) {
        this.data.setTranslation(new Vector3f((float)this.getOffsetX(), (float)offsetY, (float)this.getOffsetZ()));
    }

    @Override
    public void setOffsetZ(double offsetZ) {
        this.data.setTranslation(new Vector3f((float)this.getOffsetX(), (float)this.getOffsetY(), (float)offsetZ));
    }

    @Override
    public Location getLocation() {
        return this.data.getLocation();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public World getWorld() {
        return this.data.getLocation().getWorld();
    }

    @Override
    public double getX() {
        return this.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getZ() {
        return this.getLocation().getZ();
    }

    @Override
    public float getPitch() {
        return this.getLocation().getPitch();
    }

    @Override
    public float getYaw() {
        return this.getLocation().getYaw();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FancyHologramLine that = (FancyHologramLine)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }
}

