/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.api;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.placeholder.api.PlaceholderResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PlaceholderStore<T>
implements Listener {
    private final Map<Pattern, PlaceholderResolver<T>> resolvers = new HashMap<Pattern, PlaceholderResolver<T>>();
    private final Class<T> providerClass;
    private @Nullable T provider;
    protected final ServicePlugin plugin;

    public PlaceholderStore(ServicePlugin plugin, Class<T> providerClass) {
        this.plugin = plugin;
        this.providerClass = providerClass;
        this.updateServices();
        this.registerResolvers();
        plugin.getComponentLogger().info("Registered placeholders for {} ({})", (Object)providerClass.getSimpleName(), (Object)providerClass.getSimpleName());
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void registerResolver(Pattern pattern, PlaceholderResolver<T> resolver) {
        this.resolvers.put(pattern, resolver);
    }

    protected final void registerResolver(String regex, PlaceholderResolver<T> resolver) {
        this.resolvers.put(Pattern.compile(regex.replace("%s", "([^{}]+)")), resolver);
    }

    protected abstract void registerResolvers();

    public final @Nullable String resolve(OfflinePlayer player, String params) {
        try {
            if (this.provider != null) {
                for (Map.Entry<Pattern, PlaceholderResolver<T>> entry : this.resolvers.entrySet()) {
                    String resolved;
                    Matcher matcher = entry.getKey().matcher(params);
                    if (!matcher.matches() || (resolved = entry.getValue().resolve(this.provider, player, matcher)) == null) continue;
                    return resolved;
                }
            }
            return null;
        }
        catch (Exception e) {
            String name = player.getName() != null ? player.getName() : player.getUniqueId().toString();
            this.plugin.getComponentLogger().warn("Failed to resolve placeholder '{}' for player {}", new Object[]{params, name, e});
            return null;
        }
    }

    public final boolean isEnabled() {
        return this.provider != null;
    }

    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        if (this.providerClass.isInstance(event.getProvider().getProvider())) {
            this.updateServices();
        }
    }

    @EventHandler
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        if (this.providerClass.isInstance(event.getProvider().getProvider())) {
            this.updateServices();
        }
    }

    private void updateServices() {
        this.provider = this.plugin.getServer().getServicesManager().load(this.providerClass);
    }
}

