/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service.model;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.thenextlvl.service.api.economy.Account;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WrappedAccount
implements Account {
    private final @Nullable World world;
    private final Economy economy;
    private final OfflinePlayer holder;

    public WrappedAccount(@Nullable World world, Economy economy, OfflinePlayer holder) {
        this.world = world;
        this.economy = economy;
        this.holder = holder;
    }

    @Override
    public BigDecimal deposit(Number amount) {
        EconomyResponse response = this.economy.depositPlayer(this.holder, this.world != null ? this.world.getName() : null, amount.doubleValue());
        return new BigDecimal(response.balance);
    }

    @Override
    public BigDecimal getBalance() {
        double balance = this.economy.getBalance(this.holder, this.world != null ? this.world.getName() : null);
        return new BigDecimal(balance);
    }

    @Override
    public BigDecimal withdraw(Number amount) {
        EconomyResponse response = this.economy.withdrawPlayer(this.holder, this.world != null ? this.world.getName() : null, amount.doubleValue());
        return new BigDecimal(response.balance);
    }

    @Override
    public Optional<World> getWorld() {
        return Optional.ofNullable(this.world);
    }

    @Override
    public UUID getOwner() {
        return this.holder.getUniqueId();
    }

    @Override
    public void setBalance(Number balance) {
        double difference = balance.doubleValue() - this.getBalance().doubleValue();
        if (difference > 0.0) {
            this.deposit(difference);
        } else if (difference < 0.0) {
            this.withdraw(-difference);
        }
    }
}

