/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault2.economy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.jetbrains.annotations.NotNull;

public interface Economy {
    public boolean isEnabled();

    @NotNull
    public String getName();

    public boolean hasSharedAccountSupport();

    public boolean hasMultiCurrencySupport();

    @NotNull
    public int fractionalDigits(@NotNull String var1);

    @Deprecated
    @NotNull
    public String format(@NotNull BigDecimal var1);

    @NotNull
    public String format(@NotNull String var1, @NotNull BigDecimal var2);

    @Deprecated
    @NotNull
    public String format(@NotNull BigDecimal var1, @NotNull String var2);

    @NotNull
    public String format(@NotNull String var1, @NotNull BigDecimal var2, @NotNull String var3);

    public boolean hasCurrency(@NotNull String var1);

    @NotNull
    public String getDefaultCurrency(@NotNull String var1);

    @NotNull
    public String defaultCurrencyNamePlural(@NotNull String var1);

    @NotNull
    public String defaultCurrencyNameSingular(@NotNull String var1);

    @NotNull
    public Collection<String> currencies();

    @Deprecated
    public boolean createAccount(@NotNull UUID var1, @NotNull String var2);

    public boolean createAccount(@NotNull UUID var1, @NotNull String var2, boolean var3);

    @Deprecated
    public boolean createAccount(@NotNull UUID var1, @NotNull String var2, @NotNull String var3);

    public boolean createAccount(@NotNull UUID var1, @NotNull String var2, @NotNull String var3, boolean var4);

    @NotNull
    public Map<UUID, String> getUUIDNameMap();

    public Optional<String> getAccountName(@NotNull UUID var1);

    public boolean hasAccount(@NotNull UUID var1);

    public boolean hasAccount(@NotNull UUID var1, @NotNull String var2);

    public boolean renameAccount(@NotNull UUID var1, @NotNull String var2);

    public boolean renameAccount(@NotNull String var1, @NotNull UUID var2, @NotNull String var3);

    public boolean deleteAccount(@NotNull String var1, @NotNull UUID var2);

    public boolean accountSupportsCurrency(@NotNull String var1, @NotNull UUID var2, @NotNull String var3);

    public boolean accountSupportsCurrency(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull String var4);

    @Deprecated
    @NotNull
    public BigDecimal getBalance(@NotNull String var1, @NotNull UUID var2);

    @Deprecated
    @NotNull
    public BigDecimal getBalance(@NotNull String var1, @NotNull UUID var2, @NotNull String var3);

    @Deprecated
    @NotNull
    public BigDecimal getBalance(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull String var4);

    @NotNull
    default public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID) {
        return this.getBalance(pluginName, accountID);
    }

    @NotNull
    default public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world) {
        return this.getBalance(pluginName, accountID, world);
    }

    @NotNull
    default public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world, @NotNull String currency) {
        return this.getBalance(pluginName, accountID, world, currency);
    }

    public boolean has(@NotNull String var1, @NotNull UUID var2, @NotNull BigDecimal var3);

    public boolean has(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull BigDecimal var4);

    public boolean has(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull String var4, @NotNull BigDecimal var5);

    default public EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        BigDecimal balance = this.balance(pluginName, accountID);
        int compare = balance.compareTo(amount);
        if (compare > 0) {
            return this.withdraw(pluginName, accountID, balance.subtract(amount));
        }
        if (compare < 0) {
            return this.deposit(pluginName, accountID, amount.subtract(balance));
        }
        return new EconomyResponse(BigDecimal.ZERO, amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    default public EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        BigDecimal balance = this.balance(pluginName, accountID, worldName);
        int compare = balance.compareTo(amount);
        if (compare > 0) {
            return this.withdraw(pluginName, accountID, worldName, balance.subtract(amount));
        }
        if (compare < 0) {
            return this.deposit(pluginName, accountID, worldName, amount.subtract(balance));
        }
        return new EconomyResponse(BigDecimal.ZERO, amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    default public EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        BigDecimal balance = this.balance(pluginName, accountID, worldName, currency);
        int compare = balance.compareTo(amount);
        if (compare > 0) {
            return this.withdraw(pluginName, accountID, worldName, currency, balance.subtract(amount));
        }
        if (compare < 0) {
            return this.deposit(pluginName, accountID, worldName, currency, amount.subtract(balance));
        }
        return new EconomyResponse(BigDecimal.ZERO, amount, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String var1, @NotNull UUID var2, @NotNull BigDecimal var3);

    @NotNull
    public EconomyResponse withdraw(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull BigDecimal var4);

    @NotNull
    public EconomyResponse withdraw(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull String var4, @NotNull BigDecimal var5);

    @NotNull
    public EconomyResponse deposit(@NotNull String var1, @NotNull UUID var2, @NotNull BigDecimal var3);

    @NotNull
    public EconomyResponse deposit(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull BigDecimal var4);

    @NotNull
    public EconomyResponse deposit(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull String var4, @NotNull BigDecimal var5);

    public boolean createSharedAccount(@NotNull String var1, @NotNull UUID var2, @NotNull String var3, @NotNull UUID var4);

    default public List<String> accountsOwnedBy(@NotNull String pluginName, @NotNull UUID accountID) {
        return this.accountsAccessTo(pluginName, accountID, AccountPermission.OWNER);
    }

    default public List<String> accountsMemberOf(@NotNull String pluginName, @NotNull UUID accountID) {
        return this.accountsAccessTo(pluginName, accountID, AccountPermission.BALANCE, AccountPermission.DEPOSIT, AccountPermission.WITHDRAW);
    }

    default public List<String> accountsAccessTo(@NotNull String pluginName, @NotNull UUID accountID, AccountPermission ... permissions) {
        return new ArrayList<String>();
    }

    public boolean isAccountOwner(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3);

    public boolean setOwner(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3);

    public boolean isAccountMember(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3);

    public boolean addAccountMember(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3);

    public boolean addAccountMember(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3, AccountPermission ... var4);

    public boolean removeAccountMember(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3);

    public boolean hasAccountPermission(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3, @NotNull AccountPermission var4);

    public boolean updateAccountPermission(@NotNull String var1, @NotNull UUID var2, @NotNull UUID var3, @NotNull AccountPermission var4, boolean var5);
}

