/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.api.group;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.group.Group;
import net.thenextlvl.service.api.group.GroupHolder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface GroupController
extends Controller {
    public CompletableFuture<Group> createGroup(String var1);

    public CompletableFuture<Group> createGroup(String var1, World var2);

    public CompletableFuture<Group> loadGroup(String var1);

    public CompletableFuture<Group> loadGroup(String var1, World var2);

    default public CompletableFuture<GroupHolder> loadGroupHolder(OfflinePlayer player) {
        return this.loadGroupHolder(player.getUniqueId());
    }

    default public CompletableFuture<GroupHolder> loadGroupHolder(OfflinePlayer player, World world) {
        return this.loadGroupHolder(player.getUniqueId(), world);
    }

    public CompletableFuture<GroupHolder> loadGroupHolder(UUID var1);

    public CompletableFuture<GroupHolder> loadGroupHolder(UUID var1, World var2);

    default public CompletableFuture<Group> tryGetGroup(String name) {
        return this.getGroup(name).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroup(name));
    }

    default public CompletableFuture<Group> tryGetGroup(String name, World world) {
        return this.getGroup(name, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroup(name, world));
    }

    default public CompletableFuture<GroupHolder> tryGetGroupHolder(OfflinePlayer player) {
        return this.getGroupHolder(player).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroupHolder(player));
    }

    default public CompletableFuture<GroupHolder> tryGetGroupHolder(OfflinePlayer player, World world) {
        return this.getGroupHolder(player, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroupHolder(player, world));
    }

    default public CompletableFuture<GroupHolder> tryGetGroupHolder(UUID uuid) {
        return this.getGroupHolder(uuid).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroupHolder(uuid));
    }

    default public CompletableFuture<GroupHolder> tryGetGroupHolder(UUID uuid, World world) {
        return this.getGroupHolder(uuid, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadGroupHolder(uuid, world));
    }

    public CompletableFuture<@Unmodifiable Set<Group>> loadGroups();

    public CompletableFuture<@Unmodifiable Set<Group>> loadGroups(World var1);

    public CompletableFuture<Boolean> deleteGroup(Group var1);

    public CompletableFuture<Boolean> deleteGroup(Group var1, World var2);

    public CompletableFuture<Boolean> deleteGroup(String var1);

    public CompletableFuture<Boolean> deleteGroup(String var1, World var2);

    public Optional<Group> getGroup(String var1);

    public Optional<Group> getGroup(String var1, World var2);

    default public Optional<GroupHolder> getGroupHolder(OfflinePlayer player) {
        return this.getGroupHolder(player.getUniqueId());
    }

    default public Optional<GroupHolder> getGroupHolder(OfflinePlayer player, World world) {
        return this.getGroupHolder(player.getUniqueId(), world);
    }

    public Optional<GroupHolder> getGroupHolder(UUID var1);

    public Optional<GroupHolder> getGroupHolder(UUID var1, World var2);

    public @Unmodifiable Set<Group> getGroups();

    public @Unmodifiable Set<Group> getGroups(World var1);
}

