/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.command.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ServiceInfoCommand
extends SimpleCommand {
    private final JoinConfiguration separator = (JoinConfiguration)JoinConfiguration.builder().separator((ComponentLike)Component.text((String)", ", (TextColor)NamedTextColor.WHITE)).prefix((ComponentLike)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY)).build();

    private ServiceInfoCommand(ServicePlugin plugin) {
        super(plugin, "info", "service.info");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ServicePlugin plugin) {
        ServiceInfoCommand command = new ServiceInfoCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(Commands.literal((String)"banks").executes(command::infoBanks))).then(Commands.literal((String)"characters").executes(command::infoCharacters))).then(Commands.literal((String)"chat").executes(command::infoChat))).then(Commands.literal((String)"economy").executes(command::infoEconomy))).then(Commands.literal((String)"groups").executes(command::infoGroups))).then(Commands.literal((String)"holograms").executes(command::infoHolograms))).then(Commands.literal((String)"permissions").executes(command::infoPermissions))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "service.version", new TagResolver[]{Placeholder.parsed((String)"version", (String)this.plugin.getPluginMeta().getVersion())});
        this.infoBanks(context);
        this.infoCharacters(context);
        this.infoChat(context);
        this.infoEconomy(context);
        this.infoGroups(context);
        this.infoHolograms(context);
        this.infoPermissions(context);
        return 1;
    }

    private <C extends Controller, V> int info(CommandContext<CommandSourceStack> context, Class<C> type, @Nullable Class<V> vault, @Nullable Function<V, String> mapper, String name, String none) {
        List<TextComponent> registrations;
        Controller service;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (this.sendServiceInfo(sender, name, (service = (Controller)this.plugin.getServer().getServicesManager().load(type)) != null ? service.getName() : null, registrations = this.getRegistrations(type, service, vault, mapper))) {
            return 1;
        }
        this.plugin.bundle().sendMessage((Audience)sender, none);
        return 0;
    }

    private int infoBanks(CommandContext<CommandSourceStack> context) {
        return this.info(context, BankController.class, null, null, "Bank", "service.bank.none");
    }

    private int infoCharacters(CommandContext<CommandSourceStack> context) {
        return this.info(context, CharacterController.class, null, null, "Character", "service.character.none");
    }

    private int infoChat(CommandContext<CommandSourceStack> context) {
        return this.info(context, ChatController.class, Chat.class, Chat::getName, "Chat", "service.chat.none");
    }

    private int infoEconomy(CommandContext<CommandSourceStack> context) {
        return this.info(context, EconomyController.class, Economy.class, Economy::getName, "Economy", "service.economy.none");
    }

    private int infoGroups(CommandContext<CommandSourceStack> context) {
        return this.info(context, GroupController.class, null, null, "Group", "service.group.none");
    }

    private int infoHolograms(CommandContext<CommandSourceStack> context) {
        return this.info(context, HologramController.class, null, null, "Hologram", "service.hologram.none");
    }

    private int infoPermissions(CommandContext<CommandSourceStack> context) {
        return this.info(context, PermissionController.class, Permission.class, Permission::getName, "Permission", "service.permission.none");
    }

    private <C extends Controller, V> List<TextComponent> getRegistrations(Class<C> registration, @Nullable C loaded, @Nullable Class<V> vault, @Nullable Function<V, String> mapper) {
        String name = loaded != null ? loaded.getName() : null;
        Stream<String> registrations = this.plugin.getServer().getServicesManager().getRegistrations(registration).stream().map(RegisteredServiceProvider::getProvider).map(Controller::getName);
        Stream vaultRegistrations = vault != null && mapper != null ? this.plugin.getServer().getServicesManager().getRegistrations(vault).stream().map(RegisteredServiceProvider::getProvider).map(mapper) : Stream.empty();
        return Stream.concat(registrations, vaultRegistrations).filter(provider -> !provider.equals(name)).distinct().map(Component::text).toList();
    }

    private boolean sendServiceInfo(CommandSender sender, String type, @Nullable String provider, List<TextComponent> registrations) {
        if (provider != null) {
            this.plugin.bundle().sendMessage((Audience)sender, "service.provider.name", new TagResolver[]{Placeholder.parsed((String)"provider", (String)provider), Placeholder.parsed((String)"type", (String)type)});
        }
        if (!registrations.isEmpty()) {
            this.plugin.bundle().sendMessage((Audience)sender, "service.provider.registrations", new TagResolver[]{Placeholder.component((String)"registered", (ComponentLike)Component.join((JoinConfiguration)this.separator, registrations))});
        }
        return provider != null || !registrations.isEmpty();
    }
}

