/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.controller.permission;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.api.permission.PermissionHolder;
import net.thenextlvl.service.model.permission.LuckPermsPermissionHolder;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LuckPermsPermissionController
implements PermissionController {
    private final LuckPerms luckPerms = LuckPermsProvider.get();
    private final Plugin plugin;

    public LuckPermsPermissionController(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> new LuckPermsPermissionHolder((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid, World world) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsPermissionHolder((User)user, context);
        });
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> new LuckPermsPermissionHolder((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid, World world) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> {
            QueryOptions context = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsPermissionHolder((User)user, context);
        });
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return "LuckPerms";
    }
}

