/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.listener;

import java.util.ArrayList;
import java.util.function.Function;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.controller.character.CitizensCharacterController;
import net.thenextlvl.service.controller.character.FancyCharacterController;
import net.thenextlvl.service.controller.chat.GroupManagerChatController;
import net.thenextlvl.service.controller.chat.LuckPermsChatController;
import net.thenextlvl.service.controller.group.GroupManagerGroupController;
import net.thenextlvl.service.controller.group.LuckPermsGroupController;
import net.thenextlvl.service.controller.hologram.DecentHologramController;
import net.thenextlvl.service.controller.hologram.FancyHologramController;
import net.thenextlvl.service.controller.permission.GroupManagerPermissionController;
import net.thenextlvl.service.controller.permission.LuckPermsPermissionController;
import net.thenextlvl.service.listener.CitizensListener;
import net.thenextlvl.service.listener.FancyNpcsListener;
import net.thenextlvl.service.placeholder.api.PlaceholderExpansionBuilder;
import net.thenextlvl.service.placeholder.chat.ServiceChatPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.ServiceBankPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.ServiceEconomyPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.UnlockedEconomyPlaceholderStore;
import net.thenextlvl.service.placeholder.group.ServiceGroupPlaceholderStore;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PluginListener
implements Listener {
    private final ServicePlugin plugin;

    public PluginListener(ServicePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPluginEnable(PluginEnableEvent event) {
        switch (event.getPlugin().getName()) {
            case "PlaceholderAPI": {
                this.registerPlaceholders();
                break;
            }
            case "Citizens": {
                this.hookService(event.getPlugin(), CharacterController.class, plugin -> new CitizensCharacterController(this.plugin), controller -> new CitizensListener((CharacterController)controller), ServicePriority.Highest);
                break;
            }
            case "FancyNpcs": {
                this.hookService(event.getPlugin(), CharacterController.class, plugin -> new FancyCharacterController(this.plugin), controller -> new FancyNpcsListener((CharacterController)controller), ServicePriority.High);
                break;
            }
            case "GroupManager": {
                this.hookService(event.getPlugin(), ChatController.class, plugin -> new GroupManagerChatController(), ServicePriority.Low);
                this.hookService(event.getPlugin(), GroupController.class, plugin -> new GroupManagerGroupController(), ServicePriority.Low);
                this.hookService(event.getPlugin(), PermissionController.class, plugin -> new GroupManagerPermissionController(), ServicePriority.Low);
                break;
            }
            case "LuckPerms": {
                this.hookService(event.getPlugin(), ChatController.class, plugin -> new LuckPermsChatController((Plugin)plugin), ServicePriority.Highest);
                this.hookService(event.getPlugin(), GroupController.class, plugin -> new LuckPermsGroupController((Plugin)plugin), ServicePriority.Highest);
                this.hookService(event.getPlugin(), PermissionController.class, plugin -> new LuckPermsPermissionController((Plugin)plugin), ServicePriority.Highest);
                break;
            }
            case "DecentHolograms": {
                this.hookService(event.getPlugin(), HologramController.class, plugin -> new DecentHologramController(), ServicePriority.Highest);
                break;
            }
            case "FancyHolograms": {
                this.hookService(event.getPlugin(), HologramController.class, plugin -> new FancyHologramController(), ServicePriority.High);
            }
        }
    }

    private void registerPlaceholders() {
        new PlaceholderExpansionBuilder(this.plugin).registerStore(new ServiceBankPlaceholderStore(this.plugin)).registerStore(new ServiceChatPlaceholderStore(this.plugin)).registerStore(new ServiceEconomyPlaceholderStore(this.plugin)).registerStore(new ServiceGroupPlaceholderStore(this.plugin)).register();
        ArrayList<String> authors = new ArrayList<String>(this.plugin.getPluginMeta().getAuthors());
        authors.add("creatorfromhell");
        new PlaceholderExpansionBuilder(this.plugin, "vaultunlocked").setAuthors(authors).setVersion("2.13.1").registerStore(new UnlockedEconomyPlaceholderStore(this.plugin)).register();
    }

    private <T extends Controller> void hookService(Plugin plugin, Class<T> type, Function<Plugin, ? extends T> controller, Function<T, Listener> listener, ServicePriority priority) {
        T hook = this.hookService(plugin, type, controller, priority);
        if (hook != null) {
            plugin.getServer().getPluginManager().registerEvents(listener.apply(hook), plugin);
        }
    }

    private <T extends Controller> @Nullable T hookService(Plugin plugin, Class<T> type, Function<Plugin, ? extends T> controller, ServicePriority priority) {
        try {
            Controller provider = (Controller)controller.apply(plugin);
            this.plugin.getServer().getServicesManager().register(type, (Object)provider, plugin, priority);
            this.plugin.getComponentLogger().info("Initialized support for {} as {} ({})", new Object[]{provider.getName(), type.getSimpleName(), priority.name()});
            return (T)provider;
        }
        catch (Exception e) {
            plugin.getComponentLogger().error("Failed to add {} for {} - make sure you're using a compatible version!", new Object[]{type.getSimpleName(), plugin.getName(), e});
            return null;
        }
    }
}

