/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.model.chat;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.query.QueryOptions;
import net.thenextlvl.service.api.chat.ChatProfile;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record LuckPermsChatProfile(User user, QueryOptions options) implements ChatProfile
{
    @Override
    public Optional<String> getDisplayName() {
        return this.getInfoNode("DISPLAY_NAME");
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.user().getUsername());
    }

    @Override
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.user().getCachedData().getMetaData(this.options()).getPrefix());
    }

    @Override
    public Optional<String> getPrefix(int priority) {
        return Optional.ofNullable(this.getPrefixes().get(priority));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getPrefixes() {
        return this.user().getCachedData().getMetaData(this.options()).getPrefixes();
    }

    @Override
    public Optional<String> getPrimaryGroup() {
        return Optional.of(this.user().getPrimaryGroup());
    }

    @Override
    public Optional<String> getSuffix() {
        return Optional.ofNullable(this.user().getCachedData().getMetaData(this.options()).getSuffix());
    }

    @Override
    public Optional<String> getSuffix(int priority) {
        return Optional.ofNullable(this.getSuffixes().get(priority));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getSuffixes() {
        return this.user().getCachedData().getMetaData(this.options()).getSuffixes();
    }

    @Override
    public Set<String> getGroups() {
        return this.user().getInheritedGroups(this.options()).stream().map(Group::getName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean setDisplayName(@Nullable String displayName) {
        if (displayName == null) {
            return this.unsetDisplayName();
        }
        DataMutateResult result = this.user().data().add((Node)DisplayNameNode.builder((String)displayName).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    private boolean unsetDisplayName() {
        this.user().data().clear((ContextSet)this.options().context(), node -> node instanceof DisplayNameNode);
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return true;
    }

    @Override
    public boolean setPrefix(@Nullable String prefix, int priority) {
        if (prefix == null) {
            return this.unsetPrefix(priority);
        }
        DataMutateResult result = this.user().data().add((Node)((PrefixNode.Builder)PrefixNode.builder((String)prefix, (int)priority).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    private boolean unsetPrefix(int priority) {
        this.user().data().clear((ContextSet)this.options().context(), node -> {
            PrefixNode prefix;
            return node instanceof PrefixNode && (prefix = (PrefixNode)node).getPriority() == priority;
        });
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return true;
    }

    @Override
    public boolean setSuffix(@Nullable String suffix, int priority) {
        if (suffix == null) {
            return this.unsetSuffix(priority);
        }
        DataMutateResult result = this.user().data().add((Node)((SuffixNode.Builder)SuffixNode.builder((String)suffix, (int)priority).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    private boolean unsetSuffix(int priority) {
        this.user().data().clear((ContextSet)this.options().context(), node -> {
            SuffixNode suffix;
            return node instanceof SuffixNode && (suffix = (SuffixNode)node).getPriority() == priority;
        });
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return true;
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<String, @Nullable T> mapper) {
        return this.user().getCachedData().getMetaData(this.options()).getMetaValue(key, mapper);
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        DataMutateResult result = this.user().data().add((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    @Override
    public boolean removeInfoNode(String key) {
        this.user().data().clear((ContextSet)this.options().context(), node -> node.getKey().equals(key));
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return true;
    }

    @Override
    public boolean removeInfoNode(String key, String value) {
        DataMutateResult result = this.user().data().remove((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }
}

