/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.economy;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.economy.Account;
import net.thenextlvl.service.api.economy.bank.Bank;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.placeholder.api.PlaceholderStore;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServiceBankPlaceholderStore
extends PlaceholderStore<BankController> {
    public ServiceBankPlaceholderStore(ServicePlugin plugin) {
        super(plugin, BankController.class);
    }

    @Override
    protected void registerResolvers(BankController provider) {
        this.registerResolver("bank", (OfflinePlayer player, Matcher matcher) -> provider.getBank(player).map(Bank::getName).orElse(""));
        this.registerResolver("bank_balance", (OfflinePlayer player, Matcher matcher) -> provider.getBank(player).map(Account::getBalance).orElse(BigDecimal.ZERO).toPlainString());
        this.registerResolver("bank_balance_formatted", (OfflinePlayer player, Matcher matcher) -> provider.format(provider.getBank(player).map(Account::getBalance).orElse(BigDecimal.ZERO)));
        this.registerResolver("bank_%s", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.getBank(player, world).map(Bank::getName).orElse("");
        });
        this.registerResolver("bank_%s_balance", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.getBank(player, world).map(Account::getBalance).orElse(BigDecimal.ZERO).toPlainString();
        });
        this.registerResolver("bank_%s_balance_formatted", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.format(provider.getBank(player, world).map(Account::getBalance).orElse(BigDecimal.ZERO));
        });
        this.registerResolver("banks", (OfflinePlayer player, Matcher matcher) -> provider.getBanks().stream().map(Bank::getName).collect(Collectors.joining(", ")));
        this.registerResolver("banks_%s", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.getBanks(world).stream().map(Bank::getName).collect(Collectors.joining(", "));
        });
    }
}

